
<div class="card mb-4 card-section">
    <div class="card-header">
        <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#customerInfoCollapse" aria-expanded="true">
            <i class="ri-user-line me-2"></i> 
            <span class="fw-semibold">Step 1: Customer Information</span>
            <span class="badge bg-success ms-2" id="customerStepStatus">✓</span>
        </button>
    </div>
    <div class="collapse show" id="customerInfoCollapse" data-bs-parent="#shipmentForm">
        <div class="card-body">
            <!-- Phone Number Input -->
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="customer_phone" class="form-label required-field">Customer Phone Number</label>
                    <div class="input-group">
                        <input type="text" 
                               class="form-control" 
                               id="customer_phone" 
                               name="customer_phone" 
                               placeholder="Enter phone number"
                               value="<?php echo e($shipment->customer->phone ?? old('customer_phone')); ?>"
                               required>
                        <button type="button" class="btn btn-outline-primary" id="searchCustomerBtn">
                            <i class="ri-search-line"></i> Search
                        </button>
                    </div>
                    <div class="form-text">Enter phone number to search for existing customer</div>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Or Create New Customer</label>
                    <button type="button" class="btn btn-outline-primary w-100" data-bs-toggle="modal" data-bs-target="#newCustomerModal" id="addNewCustomerBtn">
                        <i class="ri-user-add-line"></i> Add New Customer
                    </button>
                </div>
            </div>

            <!-- Customer Details Display -->
            <div id="customerDetails" class="d-none mt-3 p-3 border rounded bg-light">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="mb-0">Customer Found</h6>
                    <span class="badge bg-success">Existing Customer</span>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-2">
                        <strong>Name:</strong> <span id="customerNameDisplay"></span>
                    </div>
                    <div class="col-md-4 mb-2">
                        <strong>Phone:</strong> <span id="customerPhoneDisplay"></span>
                    </div>
                    <div class="col-md-4 mb-2">
                        <strong>Email:</strong> <span id="customerEmailDisplay"></span>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-2">
                        <strong>ID Number:</strong> <span id="customerIdDisplay"></span>
                    </div>
                    <div class="col-md-6 mb-2">
                        <strong>Address:</strong> <span id="customerAddressDisplay"></span>
                    </div>
                </div>
                <!-- Customer Stats -->
                <div id="customerStats" class="mt-2 p-2 bg-white rounded border">
                    <!-- Stats will be loaded dynamically -->
                </div>
                <input type="hidden" id="customer_id" name="customer_id" value="<?php echo e($shipment->customer_id ?? old('customer_id')); ?>">
            </div>

            <!-- New Customer Notice -->
            <div id="newCustomerNotice" class="d-none mt-3 p-3 border rounded bg-warning bg-opacity-10">
                <div class="d-flex align-items-center">
                    <i class="ri-information-line text-warning me-2"></i>
                    <span>No customer found with this phone number. Click "Add New Customer" to create one.</span>
                </div>
            </div>

            <!-- Sending on Behalf Section -->
            <div class="form-check mt-3 mb-3">
                <input class="form-check-input" type="checkbox" id="sendingOnBehalf" name="sending_on_behalf" 
                    <?php echo e($shipment && $shipment->sending_on_behalf ? 'checked' : (old('sending_on_behalf') ? 'checked' : '')); ?>>
                <label class="form-check-label" for="sendingOnBehalf">Sending on behalf of someone else</label>
            </div>

            <div id="senderInfoSection" class="d-none mt-3 p-3 border rounded">
                <h6>Sender Information</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="sender_name" class="form-label">Sender Name</label>
                        <input type="text" class="form-control" id="sender_name" name="sender_name" 
                            value="<?php echo e($shipment->sender_name ?? old('sender_name')); ?>">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="sender_phone" class="form-label">Sender Phone</label>
                        <input type="text" class="form-control" id="sender_phone" name="sender_phone"
                            value="<?php echo e($shipment->sender_phone ?? old('sender_phone')); ?>">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="sender_id_number" class="form-label">Sender ID Number</label>
                        <input type="text" class="form-control" id="sender_id_number" name="sender_id_number"
                            value="<?php echo e($shipment->sender_id_number ?? old('sender_id_number')); ?>">
                    </div>
                </div>
            </div>

            <div class="mt-3">
                <button type="button" class="btn btn-success" id="confirmCustomerBtn" 
                    <?php echo e($shipment && $shipment->customer_id ? '' : 'disabled'); ?>>
                    <i class="ri-check-line"></i> Confirm Customer Details
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
// Define global URLs - USING LARAVEL ROUTE HELPERS
const CUSTOMER_SEARCH_URL = '<?php echo e(route("customer.ajax.search")); ?>';
const CUSTOMER_STORE_URL = '<?php echo e(route("customer.ajax.store")); ?>';

// Initialize customer section
document.addEventListener('DOMContentLoaded', function() {
    <?php if($shipment && $shipment->customer): ?>
        // If editing existing shipment with customer, display customer details
        const customer = <?php echo json_encode($shipment->customer, 15, 512) ?>;
        displayCustomerDetails(customer);
    <?php endif; ?>

    <?php if($shipment && $shipment->sending_on_behalf): ?>
        // Show sender info section if sending on behalf was checked
        document.getElementById('senderInfoSection').classList.remove('d-none');
    <?php endif; ?>

    // Add event listeners
    const searchBtn = document.getElementById('searchCustomerBtn');
    const confirmBtn = document.getElementById('confirmCustomerBtn');
    const sendingCheckbox = document.getElementById('sendingOnBehalf');
    
    if (searchBtn) {
        searchBtn.addEventListener('click', searchCustomerByPhone);
    }
    
    if (confirmBtn) {
        confirmBtn.addEventListener('click', validateCustomerSection);
    }
    
    if (sendingCheckbox) {
        sendingCheckbox.addEventListener('change', toggleSenderInfo);
    }

    // Enter key support for phone input
    const phoneInput = document.getElementById('customer_phone');
    if (phoneInput) {
        phoneInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                searchCustomerByPhone();
            }
        });
    }
});

function displayCustomerDetails(customer) {
    const nameDisplay = document.getElementById('customerNameDisplay');
    const phoneDisplay = document.getElementById('customerPhoneDisplay');
    const emailDisplay = document.getElementById('customerEmailDisplay');
    const idDisplay = document.getElementById('customerIdDisplay');
    const addressDisplay = document.getElementById('customerAddressDisplay');
    const customerDetails = document.getElementById('customerDetails');
    const customerIdInput = document.getElementById('customer_id');
    const confirmBtn = document.getElementById('confirmCustomerBtn');
    
    if (nameDisplay) nameDisplay.textContent = customer.name || 'N/A';
    if (phoneDisplay) phoneDisplay.textContent = customer.phone;
    if (emailDisplay) emailDisplay.textContent = customer.email || 'N/A';
    if (idDisplay) idDisplay.textContent = customer.id_number || 'N/A';
    
    // Format address
    const addressParts = [];
    if (customer.address) addressParts.push(customer.address);
    if (customer.city) addressParts.push(customer.city);
    if (customer.country && customer.country.name) addressParts.push(customer.country.name);
    if (addressDisplay) addressDisplay.textContent = addressParts.join(', ') || 'N/A';
    
    if (customerDetails) customerDetails.classList.remove('d-none');
    if (customerIdInput) customerIdInput.value = customer.id;
    if (confirmBtn) confirmBtn.disabled = false;

    // Update verification fields
    updateVerificationFields(customer.phone);
    
    // Load customer stats
    loadCustomerStats(customer.id);
}

function updateVerificationFields(phone) {
    const otpPhone = document.getElementById('otp_phone');
    const whatsappNumber = document.getElementById('whatsapp_number');
    
    if (otpPhone) otpPhone.value = phone;
    if (whatsappNumber) whatsappNumber.value = phone;
}

function toggleSenderInfo() {
    const senderSection = document.getElementById('senderInfoSection');
    const sendingCheckbox = document.getElementById('sendingOnBehalf');
    
    if (senderSection && sendingCheckbox) {
        senderSection.classList.toggle('d-none', !sendingCheckbox.checked);
    }
}

// Global functions
window.searchCustomerByPhone = searchCustomerByPhone;
window.validateCustomerSection = validateCustomerSection;
window.saveNewCustomer = saveNewCustomer;

// Export functions for module use
if (typeof module !== 'undefined' && module.exports) {
    module.exports = {
        searchCustomerByPhone,
        validateCustomerSection,
        saveNewCustomer,
        displayCustomerDetails
    };
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipments/partials/customer-info.blade.php ENDPATH**/ ?>