<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'services' => [],
    'currencies' => [],
    'selectedServices' => [],
    'baseCurrency' => 'KES'
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'services' => [],
    'currencies' => [],
    'selectedServices' => [],
    'baseCurrency' => 'KES'
]); ?>
<?php foreach (array_filter(([
    'services' => [],
    'currencies' => [],
    'selectedServices' => [],
    'baseCurrency' => 'KES'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="card mb-4 card-section" id="servicesSection">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>Extra Services</span>
        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#servicesHelpModal">
            <i class="ri-information-line"></i> Help
        </button>
    </div>
    <div class="card-body">
        <div class="row g-3 mb-3">
            <div class="col-md-4">
                <label class="form-label">Service</label>
                <select class="form-select" id="service_id" required>
                    <option value="">-- Select --</option>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($service->id); ?>" 
                                data-description="<?php echo e($service->description); ?>"
                                data-default-cost="<?php echo e($service->default_cost); ?>"
                                data-default-charge="<?php echo e($service->default_charge); ?>"
                                data-currency="<?php echo e($service->default_currency); ?>">
                            <?php echo e($service->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <div class="invalid-feedback">Please select a service</div>
            </div>
            <div class="col-md-2">
                <label class="form-label">Cost</label>
                <input type="number" step="0.01" min="0" class="form-control" id="service_cost" placeholder="0.00" required>
                <div class="invalid-feedback">Please enter a valid cost</div>
            </div>
            <div class="col-md-2">
                <label class="form-label">Charge</label>
                <input type="number" step="0.01" min="0" class="form-control" id="service_charge" placeholder="0.00" required>
                <div class="invalid-feedback">Please enter a valid charge</div>
            </div>
            <div class="col-md-2">
                <label class="form-label">Currency</label>
                <select class="form-select" id="service_currency" required>
                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($currency->code); ?>" 
                                data-buy-rate="<?php echo e($currency->buying_exchange_rate); ?>"
                                data-sell-rate="<?php echo e($currency->selling_exchange_rate); ?>"
                                <?php echo e($currency->code === $baseCurrency ? 'selected' : ''); ?>>
                            <?php echo e($currency->code); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="button" class="btn btn-primary w-100" id="addService">
                    <i class="ri-add-line"></i> Add
                </button>
            </div>
        </div>

        <div class="service-description mb-3 alert alert-info d-none" id="serviceDescription"></div>
        
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="estimated-profit alert alert-success py-1 px-2 mb-0 d-none" id="estimatedProfitDisplay">
                Estimated Profit: 0.00 <?php echo e($baseCurrency); ?>

            </div>
            <button type="button" class="btn btn-sm btn-outline-secondary" id="clearServices">
                <i class="ri-close-line"></i> Clear All
            </button>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-hover" id="servicesTable">
                <thead class="table-light">
                    <tr>
                        <th>Service</th>
                        <th>Currency</th>
                        <th>Cost</th>
                        <th>Charge</th>
                        <th>Cost (<?php echo e($baseCurrency); ?>)</th>
                        <th>Charge (<?php echo e($baseCurrency); ?>)</th>
                        <th>Profit</th>
                        <th width="100px">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($selectedServices) > 0): ?>
                        <?php $__currentLoopData = $selectedServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                // Convert service to array if it's an object
                                $serviceArray = is_object($service) ? $service->toArray() : $service;
                            ?>
                            <tr data-service-id="<?php echo e($serviceArray['id']); ?>">
                                <td>
                                    <?php echo e($services->find($serviceArray['id'])->name); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][id]" value="<?php echo e($serviceArray['id']); ?>">
                                </td>
                                <td>
                                    <?php echo e($serviceArray['currency']); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][currency]" value="<?php echo e($serviceArray['currency']); ?>">
                                </td>
                                <td>
                                    <?php echo e(number_format($serviceArray['cost'], 2)); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][cost]" value="<?php echo e($serviceArray['cost']); ?>">
                                </td>
                                <td>
                                    <?php echo e(number_format($serviceArray['charge'], 2)); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][charge]" value="<?php echo e($serviceArray['charge']); ?>">
                                </td>
                                <td><?php echo e(number_format($serviceArray['cost_kes'], 2)); ?></td>
                                <td><?php echo e(number_format($serviceArray['charge_kes'], 2)); ?></td>
                                <td class="<?php echo e($serviceArray['charge_kes'] - $serviceArray['cost_kes'] >= 0 ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e(number_format($serviceArray['charge_kes'] - $serviceArray['cost_kes'], 2)); ?>

                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-danger remove-service" title="Remove">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr id="noServicesRow">
                            <td colspan="8" class="text-center py-4 text-muted">No services added yet</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                <tfoot class="table-light">
                    <tr>
                        <th colspan="2">Totals</th>
                        <?php
                            // Use Collection methods instead of array_column for better compatibility
                            $totalCost = is_object($selectedServices) ? $selectedServices->sum('cost') : array_sum(array_column($selectedServices, 'cost'));
                            $totalCharge = is_object($selectedServices) ? $selectedServices->sum('charge') : array_sum(array_column($selectedServices, 'charge'));
                            $totalCostKES = is_object($selectedServices) ? $selectedServices->sum('cost_kes') : array_sum(array_column($selectedServices, 'cost_kes'));
                            $totalChargeKES = is_object($selectedServices) ? $selectedServices->sum('charge_kes') : array_sum(array_column($selectedServices, 'charge_kes'));
                            $totalProfit = $totalChargeKES - $totalCostKES;
                        ?>
                        <th id="totalCost"><?php echo e(number_format($totalCost, 2)); ?></th>
                        <th id="totalCharge"><?php echo e(number_format($totalCharge, 2)); ?></th>
                        <th id="totalCostKES"><?php echo e(number_format($totalCostKES, 2)); ?></th>
                        <th id="totalChargeKES"><?php echo e(number_format($totalChargeKES, 2)); ?></th>
                        <th id="totalProfit" class="<?php echo e($totalProfit >= 0 ? 'text-success' : 'text-danger'); ?>">
                            <?php echo e(number_format($totalProfit, 2)); ?>

                        </th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const serviceSelect = document.getElementById('service_id');
    const costInput = document.getElementById('service_cost');
    const chargeInput = document.getElementById('service_charge');
    const currencySelect = document.getElementById('service_currency');
    const addBtn = document.getElementById('addService');
    const clearBtn = document.getElementById('clearServices');
    const servicesTable = document.getElementById('servicesTable');
    const serviceDescription = document.getElementById('serviceDescription');
    const profitDisplay = document.getElementById('estimatedProfitDisplay');
    const baseCurrency = '<?php echo e($baseCurrency); ?>';
    
    // Initialize form validation
    const form = document.getElementById('shipmentForm');
    const pricingManager = window.shipmentApp?.components?.pricingManager;
    
    // Show service description when selected
    serviceSelect.addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const description = selectedOption.dataset.description;
        const defaultCost = selectedOption.dataset.defaultCost;
        const defaultCharge = selectedOption.dataset.defaultCharge;
        const defaultCurrency = selectedOption.dataset.currency;
        
        if (description) {
            serviceDescription.textContent = description;
            serviceDescription.classList.remove('d-none');
        } else {
            serviceDescription.classList.add('d-none');
        }
        
        // Set default values
        if (defaultCost) costInput.value = parseFloat(defaultCost).toFixed(2);
        if (defaultCharge) chargeInput.value = parseFloat(defaultCharge).toFixed(2);
        
        // Set currency if different from current selection
        if (defaultCurrency && defaultCurrency !== currencySelect.value) {
            const currencyOption = [...currencySelect.options].find(opt => opt.value === defaultCurrency);
            if (currencyOption) {
                currencySelect.value = defaultCurrency;
            }
        }
        
        updateProfitEstimate();
    });
    
    // Update profit estimate on input changes
    costInput.addEventListener('input', updateProfitEstimate);
    chargeInput.addEventListener('input', updateProfitEstimate);
    currencySelect.addEventListener('change', updateProfitEstimate);
    
    function updateProfitEstimate() {
        const cost = parseFloat(costInput.value) || 0;
        const charge = parseFloat(chargeInput.value) || 0;
        const currency = currencySelect.value;
        const currencyOption = currencySelect.options[currencySelect.selectedIndex];
        const buyRate = parseFloat(currencyOption.dataset.buyRate) || 1;
        const sellRate = parseFloat(currencyOption.dataset.sellRate) || 1;
        
        const costKES = cost * buyRate;
        const chargeKES = charge * sellRate;
        const profit = chargeKES - costKES;
        
        if (profitDisplay) {
            profitDisplay.textContent = `Estimated Profit: ${profit.toFixed(2)} ${baseCurrency}`;
            profitDisplay.classList.remove('d-none');
            profitDisplay.classList.remove('alert-success', 'alert-danger');
            profitDisplay.classList.add(profit >= 0 ? 'alert-success' : 'alert-danger');
        }
    }
    
    // Add service to table
    addBtn.addEventListener('click', function() {
        if (!form.checkValidity()) {
            form.classList.add('was-validated');
            return;
        }
        
        const serviceId = serviceSelect.value;
        const serviceOption = serviceSelect.options[serviceSelect.selectedIndex];
        const serviceName = serviceOption.text;
        const cost = parseFloat(costInput.value) || 0;
        const charge = parseFloat(chargeInput.value) || 0;
        const currency = currencySelect.value;
        const currencyOption = currencySelect.options[currencySelect.selectedIndex];
        const buyRate = parseFloat(currencyOption.dataset.buyRate) || 1;
        const sellRate = parseFloat(currencyOption.dataset.sellRate) || 1;
        
        // Calculate values in base currency
        const costKES = cost * buyRate;
        const chargeKES = charge * sellRate;
        const profit = chargeKES - costKES;
        
        // Remove "no services" row if it exists
        const noServicesRow = document.getElementById('noServicesRow');
        if (noServicesRow) noServicesRow.remove();
        
        // Generate unique index for new service
        const serviceIndex = Date.now();
        
        // Add new row
        const newRow = servicesTable.querySelector('tbody').insertRow();
        newRow.setAttribute('data-service-id', serviceId);
        newRow.innerHTML = `
            <td>
                ${serviceName}
                <input type="hidden" name="services[${serviceIndex}][id]" value="${serviceId}">
            </td>
            <td>
                ${currency}
                <input type="hidden" name="services[${serviceIndex}][currency]" value="${currency}">
            </td>
            <td>
                ${cost.toFixed(2)}
                <input type="hidden" name="services[${serviceIndex}][cost]" value="${cost}">
            </td>
            <td>
                ${charge.toFixed(2)}
                <input type="hidden" name="services[${serviceIndex}][charge]" value="${charge}">
            </td>
            <td>${costKES.toFixed(2)}</td>
            <td>${chargeKES.toFixed(2)}</td>
            <td class="${profit >= 0 ? 'text-success' : 'text-danger'}">${profit.toFixed(2)}</td>
            <td>
                <button type="button" class="btn btn-sm btn-danger remove-service" title="Remove">
                    <i class="ri-delete-bin-line"></i>
                </button>
            </td>
        `;
        
        // Update totals
        updateServiceTotals();
        
        // Clear inputs
        serviceSelect.selectedIndex = 0;
        costInput.value = '';
        chargeInput.value = '';
        serviceDescription.classList.add('d-none');
        profitDisplay.classList.add('d-none');
        form.classList.remove('was-validated');
    });
    
    // Clear all services
    clearBtn.addEventListener('click', function() {
        if (confirm('Are you sure you want to remove all services?')) {
            servicesTable.querySelector('tbody').innerHTML = `
                <tr id="noServicesRow">
                    <td colspan="8" class="text-center py-4 text-muted">No services added yet</td>
                </tr>
            `;
            updateServiceTotals();
        }
    });
    
    // Remove service
    servicesTable.addEventListener('click', function(e) {
        if (e.target.closest('.remove-service')) {
            const row = e.target.closest('tr');
            if (confirm('Are you sure you want to remove this service?')) {
                row.remove();
                
                // Add "no services" row if table is empty
                if (servicesTable.querySelector('tbody').rows.length === 0) {
                    const tbody = servicesTable.querySelector('tbody');
                    tbody.innerHTML = `
                        <tr id="noServicesRow">
                            <td colspan="8" class="text-center py-4 text-muted">No services added yet</td>
                        </tr>
                    `;
                }
                
                updateServiceTotals();
            }
        }
    });
    
    // Calculate and update service totals
    function updateServiceTotals() {
        const rows = servicesTable.querySelectorAll('tbody tr:not(#noServicesRow)');
        let totalCost = 0;
        let totalCharge = 0;
        let totalCostKES = 0;
        let totalChargeKES = 0;
        
        rows.forEach(row => {
            totalCost += parseFloat(row.cells[2].textContent) || 0;
            totalCharge += parseFloat(row.cells[3].textContent) || 0;
            totalCostKES += parseFloat(row.cells[4].textContent) || 0;
            totalChargeKES += parseFloat(row.cells[5].textContent) || 0;
        });
        
        const totalProfit = totalChargeKES - totalCostKES;
        
        // Update footer
        document.getElementById('totalCost').textContent = totalCost.toFixed(2);
        document.getElementById('totalCharge').textContent = totalCharge.toFixed(2);
        document.getElementById('totalCostKES').textContent = totalCostKES.toFixed(2);
        document.getElementById('totalChargeKES').textContent = totalChargeKES.toFixed(2);
        document.getElementById('totalProfit').textContent = totalProfit.toFixed(2);
        document.getElementById('totalProfit').className = totalProfit >= 0 ? 'text-success' : 'text-danger';
        
        // Update pricing manager if available
        if (pricingManager) {
            pricingManager.updateServices(totalChargeKES);
        }
    }
    
    // Initialize with existing services
    if (document.querySelectorAll('#servicesTable tbody tr:not(#noServicesRow)').length > 0) {
        updateServiceTotals();
    }
});
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\resources\views/shipments/partials/services.blade.php ENDPATH**/ ?>