<div class="card mb-4 card-section">
    <div class="card-header">Pricing Summary</div>
    <div class="card-body">
        <div class="row">
            <!-- Freight Charges (Original Currency) -->
            <div class="col-md-4 mb-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="card-title mb-0 text-muted">
                                <i class="ri-truck-line me-2"></i> Freight Charges
                            </h6>
                            <span class="badge bg-primary-soft">
                                Original: 
                                <span id="freightCurrencyOriginal"><?php echo e($baseCurrency); ?></span>
                            </span>
                        </div>
                        <div class="d-flex align-items-end">
                            <h3 class="mb-0" id="freightAmountOriginal">0.00</h3>
                            <span class="ms-2 text-muted" id="freightCurrencyDisplay"></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Freight Charges (KES) -->
            <div class="col-md-4 mb-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="card-title mb-0 text-muted">
                                <i class="ri-exchange-line me-2"></i> Freight (<?php echo e($baseCurrency); ?>)
                            </h6>
                            <span class="badge bg-primary-soft">Converted</span>
                        </div>
                        <div class="d-flex align-items-end">
                            <h3 class="mb-0" id="freightAmountKES">0.00</h3>
                            <span class="ms-2 text-muted"><?php echo e($baseCurrency); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Service Charges (Always in KES) -->
            <div class="col-md-4 mb-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <h6 class="card-title text-muted mb-3">
                            <i class="ri-service-line me-2"></i> Service Charges
                        </h6>
                        <div class="d-flex align-items-end">
                            <h3 class="mb-0" id="servicesAmount">0.00</h3>
                            <span class="ms-2 text-muted"><?php echo e($baseCurrency); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Amount with Currency Switcher -->
        <div class="row">
            <div class="col-md-12">
                <div class="card border-0 shadow-sm border-primary">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="card-title text-primary mb-0">
                                <i class="ri-money-dollar-circle-line me-2"></i> Total Amount
                            </h6>
                            <span class="badge bg-primary">Summary</span>
                        </div>
                        <div class="d-flex align-items-end mb-3">
                            <h2 class="mb-0 text-primary" id="totalAmount">0.00</h2>
                            <span class="ms-2 text-primary currency-display"><?php echo e($baseCurrency); ?></span>
                        </div>
                        
                        <div class="currency-switcher">
                            <label class="form-label small text-muted mb-1">Display total in:</label>
                            <select class="form-select form-select-sm" id="currencySwitcher">
                                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($currency->code); ?>" 
                                            data-sell-rate="<?php echo e($currency->selling_exchange_rate); ?>"
                                            <?php echo e($currency->code === $baseCurrency ? 'selected' : ''); ?>>
                                        <?php echo e($currency->code); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="mt-1">
                                <small class="text-muted">
                                    <span id="exchangeRateDisplay">1 <?php echo e($baseCurrency); ?> = 1 <?php echo e($baseCurrency); ?></span>
                                    <span id="currencyLoading" class="ms-2" style="display:none;">
                                        <i class="ri-loader-4-line spin"></i>
                                    </span>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize nice-select if available
        if (typeof $.fn.niceSelect === 'function') {
            $('#currencySwitcher').niceSelect();
        }

        // Simple way to pass currency data to JavaScript
        window.currencyData = {
            baseCurrency: '<?php echo e($baseCurrency); ?>',
            currencies: <?php echo $currencies->toJson(); ?>

        };
    });
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\MAMP\htdocs\smart-shipping\resources\views/shipments/partials/summary.blade.php ENDPATH**/ ?>