<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-centered table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Vendor Code</th>
                                <th>Service Provider</th>
                                <th>Type</th>
                                <th>Onboarding Date</th>
                                <th>Open Balance</th>
                                <th>Routes</th>
                                <th>Status</th>
                                <th width="120px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $serviceProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr data-vendor-id="<?php echo e($provider->id); ?>" data-vendor-type="service-provider" data-status="<?php echo e($provider->status); ?>">
                                    <td>
                                        <span class="badge bg-primary"><?php echo e($provider->vendor_code); ?></span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <img src="https://ui-avatars.com/api/?name=<?php echo e(urlencode($provider->name)); ?>&background=4a81d4&color=fff" 
                                                     alt="logo" class="rounded-circle" width="40">
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <h6 class="mb-0"><?php echo e($provider->name); ?></h6>
                                                <small class="text-muted"><?php echo e($provider->email); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($provider->is_default): ?>
                                            <span class="badge bg-success">Default (Inhouse)</span>
                                        <?php else: ?>
                                            <span class="badge bg-info"><?php echo e(ucfirst($provider->type)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($provider->onboarding_date->format('M d, Y')); ?></td>
                                    <td>
                                        <span class="fw-bold <?php echo e($provider->open_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                                            KES <?php echo e(number_format($provider->open_balance, 2)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark"><?php echo e($provider->routes_count ?? 0); ?> routes</span>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo e($provider->status === 'active' ? 'bg-success' : 'bg-danger'); ?>">
                                            <?php echo e(ucfirst($provider->status)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button type="button" class="btn btn-outline-primary" 
                                                    data-action="view" data-vendor-id="<?php echo e($provider->id); ?>"
                                                    title="View Details">
                                                <i class="ri-eye-line"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-success"
                                                    data-action="payment" data-vendor-id="<?php echo e($provider->id); ?>"
                                                    title="Make Payment">
                                                <i class="ri-money-dollar-circle-line"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-info"
                                                    data-action="summary" data-vendor-id="<?php echo e($provider->id); ?>"
                                                    title="Generate Summary">
                                                <i class="ri-file-list-3-line"></i>
                                            </button>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <button type="button" class="btn btn-outline-warning dropdown-toggle" 
                                                        data-bs-toggle="dropdown" title="More Actions">
                                                    <i class="ri-more-2-fill"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-action="edit" data-vendor-id="<?php echo e($provider->id); ?>">
                                                            <i class="ri-edit-line me-1"></i> Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-action="routes" data-vendor-id="<?php echo e($provider->id); ?>">
                                                            <i class="ri-route-line me-1"></i> Manage Routes
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-action="toggle-status" data-vendor-id="<?php echo e($provider->id); ?>">
                                                            <i class="ri-toggle-line me-1"></i> Toggle Status
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#" 
                                                           data-action="delete" data-vendor-id="<?php echo e($provider->id); ?>">
                                                            <i class="ri-delete-bin-line me-1"></i> Delete
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="row mt-3">
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_info">
                            Showing <?php echo e($serviceProviders->firstItem()); ?> to <?php echo e($serviceProviders->lastItem()); ?> of <?php echo e($serviceProviders->total()); ?> entries
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers float-end">
                            <?php echo e($serviceProviders->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/vendor/service-providers/partials/providers-table.blade.php ENDPATH**/ ?>