

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <h4>Shipment Routes</h4>
    <a href="<?php echo e(route('shipment-routes.create')); ?>" class="btn btn-primary mb-3">+ New Route</a>

    <table class="table table-bordered table-striped">
      <thead>
        <tr>
          <th>Route</th>
          <th>Mode</th>
          <th>Measure</th>
          <th>Category</th>
          <th>Unit Type</th>
          <th>Rate/Unit</th>
          <th>Min Weight</th>
          <th>Flat Rate</th>
          <th>Currency</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <tr>
            <td><?php echo e($r->originCountry?->code ?? '-'); ?> → <?php echo e($r->destinationCountry?->code ?? '-'); ?></td>
            <td><?php echo e($r->shipmentMode?->name ?? '-'); ?></td>
            <td><?php echo e($r->shipmentMode?->measure?->code ?? '-'); ?></td>
            <td><?php echo e($r->cargoCategory?->name ?? '-'); ?></td>
            <td><?php echo e(strtoupper($r->unit_type ?? '-')); ?></td>
            <td><?php echo e(number_format($r->rate_per_unit, 2) ?? '-'); ?></td>
            <td><?php echo e(number_format($r->minimum_weight, 2) ?? '-'); ?></td>
            <td><?php echo e(number_format($r->flat_rate, 2) ?? '-'); ?></td>
            <td><?php echo e($r->currency?->code ?? '-'); ?></td>
            <td>
              <a href="<?php echo e(route('shipment-routes.edit', $r)); ?>" class="btn btn-sm btn-warning">Edit</a>
              <form action="<?php echo e(route('shipment-routes.destroy', $r)); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr>
            <td colspan="10" class="text-center text-muted">No shipment routes defined yet.</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.clivax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\MAMP\htdocs\smart-shipping\resources\views/shipment_routes/index.blade.php ENDPATH**/ ?>