

<?php $__env->startSection('title', 'Currency Exchange Rates'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center py-3">
            <h5 class="mb-0">
                <i class="ri-exchange-dollar-line me-2"></i>Currency Exchange Rates
            </h5>
            <a href="<?php echo e(route('currencies.create')); ?>" class="btn btn-light">
                <i class="ri-add-line me-1"></i> Add Currency
            </a>
        </div>
        
        <div class="card-body p-0">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show m-3" role="alert">
                    <i class="ri-check-line me-2"></i><?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show m-3" role="alert">
                    <i class="ri-error-warning-line me-2"></i><?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th class="ps-4">Code</th>
                            <th>Name</th>
                            <th>Symbol</th>
                            <th class="text-end pe-4">Buying Rate</th>
                            <th class="text-end pe-4">Selling Rate</th>
                            <th class="text-end pe-4">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php echo e($currency->code === 'KES' ? 'table-active' : ''); ?>">
                            <td class="ps-4 fw-bold"><?php echo e($currency->code); ?></td>
                            <td><?php echo e($currency->name); ?></td>
                            <td>
                                <?php if($currency->symbol): ?>
                                    <span class="badge bg-light text-dark border"><?php echo e($currency->symbol); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-end pe-4"><?php echo e(number_format($currency->buying_exchange_rate, 4)); ?> KES</td>
                            <td class="text-end pe-4"><?php echo e(number_format($currency->selling_exchange_rate, 4)); ?> KES</td>
                            <td class="text-end pe-4">
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="<?php echo e(route('currencies.edit', $currency->id)); ?>" 
                                       class="btn btn-sm btn-outline-primary rounded-circle"
                                       title="Edit"
                                       data-bs-toggle="tooltip">
                                        <i class="ri-edit-line"></i>
                                    </a>
                                    
                                    <?php if($currency->code !== 'KES'): ?>
                                        <form action="<?php echo e(route('currencies.destroy', $currency->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" 
                                                    class="btn btn-sm btn-outline-danger rounded-circle"
                                                    onclick="return confirm('Are you sure you want to delete this currency?')"
                                                    title="<?php echo e($currency->services()->exists() ? 'Currency is in use' : 'Delete'); ?>"
                                                    <?php if($currency->services()->exists()): ?> disabled <?php endif; ?>
                                                    data-bs-toggle="tooltip">
                                                <i class=" far fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <i class="ri-exchange-funds-line display-5"></i>
                                <p class="mt-2">No currencies found</p>
                                <a href="<?php echo e(route('currencies.create')); ?>" class="btn btn-primary mt-2">
                                    <i class="ri-add-line me-1"></i> Add First Currency
                                </a>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if($currencies->hasPages()): ?>
            <div class="card-footer bg-transparent">
                <div class="d-flex justify-content-center">
                    <?php echo e($currencies->links('vendor.pagination.bootstrap-5')); ?>

                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Initialize tooltips
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.clivax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/currencies/index.blade.php ENDPATH**/ ?>