<div class="row">
    <div class="col-md-6 mb-3">
        <label>Origin Country</label>
        <select name="origin_country_id" id="origin_country_id" class="form-control" required>
            <option value="">Select Origin</option>
            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($country->id); ?>" 
                    <?php echo e(old('origin_country_id', $shipment->origin_country_id ?? '') == $country->id ? 'selected' : ''); ?>>
                    <?php echo e($country->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-6 mb-3">
        <label>Destination Country</label>
        <select name="destination_country_id" id="destination_country_id" class="form-control" required>
            <option value="">Select Destination</option>
            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($country->id); ?>" 
                    <?php echo e(old('destination_country_id', $shipment->destination_country_id ?? '') == $country->id ? 'selected' : ''); ?>>
                    <?php echo e($country->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-6 mb-3">
        <label>Shipment Mode</label>
        <select name="shipment_mode_code" id="shipment_mode_select" class="form-control" required>
            <option value="">Select Mode</option>
            <?php $__currentLoopData = $shipmentModes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($mode->code); ?>" 
                    data-measure="<?php echo e($mode->measure->code ?? ''); ?>"
                    <?php echo e(old('shipment_mode_code', $shipment->shipment_mode_code ?? '') == $mode->code ? 'selected' : ''); ?>>
                    <?php echo e($mode->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="col-md-6 mb-3">
        <label>Cargo Category</label>
        <select name="cargo_category_id" id="cargo_category_id" class="form-control" required>
            <option value="">Select Category</option>
            <?php $__currentLoopData = $cargoCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($cat->id); ?>" 
                    <?php echo e(old('cargo_category_id', $shipment->cargo_category_id ?? '') == $cat->id ? 'selected' : ''); ?>>
                    <?php echo e($cat->name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>

<!-- Add this section to display rate information -->
<div class="row mb-3">
    <div class="col-md-4">
        <div class="card bg-light">
            <div class="card-body">
                <h6 class="card-title">Applicable Rate</h6>
                <div id="rateDisplay">
                    <p class="mb-0">Select route to see rate</p>
                </div>
            </div>
        </div>
    </div>
    
    </div>
    <div class="col-md-4">
        <div class="card bg-light">
            <div class="card-body">
                <h6 class="card-title">Currency</h6>
                <div id="currencyDisplay">
                    <p class="mb-0">KES (default)</p>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\resources\views/shipments/partials/route-details.blade.php ENDPATH**/ ?>