<div class="accordion mb-4" id="consigneeAccordion">
    <div class="accordion-item">
        <h2 class="accordion-header" id="headingConsignee">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseConsignee" aria-expanded="false" aria-controls="collapseConsignee">
                Consignee Information
            </button>
        </h2>
        <div id="collapseConsignee" class="accordion-collapse collapse" aria-labelledby="headingConsignee" data-bs-parent="#consigneeAccordion">
            <div class="accordion-body">
                <div class="row g-3">
                    <!-- Column 1 -->
                    <div class="col-md-6">
                        <label for="consignee_name" class="form-label">Consignee Name</label>
                        <input type="text" class="form-control" id="consignee_name" name="consignee_name" value="<?php echo e(old('consignee_name', $shipment->consignee_name ?? '')); ?>">

                        <label for="consignee_email" class="form-label mt-3">Email</label>
                        <input type="email" class="form-control" id="consignee_email" name="consignee_email" value="<?php echo e(old('consignee_email', $shipment->consignee_email ?? '')); ?>">

                        <label for="consignee_address" class="form-label mt-3">Address</label>
                        <input type="text" class="form-control" id="consignee_address" name="consignee_address" placeholder="1234 Main St" value="<?php echo e(old('consignee_address', $shipment->consignee_address ?? '')); ?>">

                        <label for="consignee_city" class="form-label mt-3">City</label>
                        <input type="text" class="form-control" id="consignee_city" name="consignee_city" value="<?php echo e(old('consignee_city', $shipment->consignee_city ?? '')); ?>">
                    </div>

                    <!-- Column 2 -->
                    <div class="col-md-6">
                        <label for="consignee_company" class="form-label">Company</label>
                        <input type="text" class="form-control" id="consignee_company" name="consignee_company" value="<?php echo e(old('consignee_company', $shipment->consignee_company ?? '')); ?>">

                        <label for="consignee_address2" class="form-label mt-3">Address 2</label>
                        <input type="text" class="form-control" id="consignee_address2" name="consignee_address2" placeholder="Apartment, studio, or floor" value="<?php echo e(old('consignee_address2', $shipment->consignee_address2 ?? '')); ?>">

                        <label for="consignee_country_id" class="form-label mt-3">Country</label>
                        <select id="consignee_country_id" name="consignee_country_id" class="form-select">
                            <option value="">Choose...</option>
                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($country->id); ?>" <?php echo e(old('consignee_country_id', $shipment->consignee_country_id ?? '') == $country->id ? 'selected' : ''); ?>>
                                    <?php echo e($country->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        <label for="consignee_phone" class="form-label mt-3">Telephone</label>
                        <input type="text" class="form-control" id="consignee_phone" name="consignee_phone" value="<?php echo e(old('consignee_phone', $shipment->consignee_phone ?? '')); ?>">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipments/partials/consignee-info.blade.php ENDPATH**/ ?>