<?php
use App\Models\Currency;
$baseCurrency = Currency::base()->code;
$currencies = Currency::all();
?>

<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'action' => '#',
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'action' => '#',
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]); ?>
<?php foreach (array_filter(([
    'action' => '#',
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<form id="shipmentForm" method="POST" action="<?php echo e($action); ?>" class="card p-4" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php if($method !== 'POST'): ?>
        <?php echo method_field($method); ?>
    <?php endif; ?>

    <!-- Currency Handling Fields -->
    <input type="hidden" name="base_currency" value="<?php echo e($baseCurrency); ?>">
    <input type="hidden" name="original_currency" id="originalCurrency" value="<?php echo e($baseCurrency); ?>">
    <input type="hidden" name="exchange_rate" id="exchangeRate" value="1">

    <!-- Customer Section -->
    <div class="card mb-4 card-section">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Customer Information</span>
            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#customerHelpModal">
                <i class="ri-information-line"></i> Help
            </button>
        </div>
        <div class="card-body row">
            <!-- Customer fields remain unchanged -->
        </div>
    </div>

    <!-- Route Details -->
    <div class="card mb-4 card-section">
        <div class="card-header">Route Details</div>
        <div class="card-body">
            <?php echo $__env->make('shipments.partials.route-details', [
                'countries' => $countries,
                'shipmentModes' => $shipmentModes,
                'cargoCategories' => $cargoCategories,
                'shipment' => $shipment
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

    <!-- Package Details -->
    <?php echo $__env->make('shipments.partials.package-details', [
        'packages' => $shipment->packages ?? [],
        'shipmentModes' => $shipmentModes
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Services Section -->
    <?php echo $__env->make('shipments.partials.services', [
        'services' => $services,
        'currencies' => $currencies,
        'selectedServices' => $shipment->services ?? []
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Pricing Summary Section -->
<!-- Pricing Summary Section -->
    <div class="card mb-4 card-section">
        <div class="card-header">Pricing Summary</div>
        <div class="card-body">
            <?php echo $__env->make('shipments.partials.summary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

    <!-- Form Actions -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <button type="button" class="btn btn-secondary" onclick="window.history.back()">
                    <i class="ri-arrow-left-line"></i> Back
                </button>
                <button type="submit" class="btn btn-primary">
                    <i class="ri-save-line"></i> <?php echo e($method === 'PUT' ? 'Update' : 'Create'); ?> Shipment
                </button>
            </div>
        </div>
    </div>

  


</form>
<!-- Manual Rate Modal -->
    <div class="modal fade" id="manualRateModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title"><i class="ri-money-dollar-circle-line me-2"></i> Set Manual Rate</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="manualRateForm" novalidate>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label" for="manualRateValue">
                                Rate Value <span class="text-danger">*</span>
                            </label>
                            <div class="input-group">
                                <input type="number" class="form-control" id="manualRateValue" 
                                       name="manual_rate_value" step="0.0001" min="0.0001" required
                                       placeholder="Enter rate value">
                                <span class="input-group-text" id="rateCurrencyDisplay"><?php echo e($baseCurrency); ?></span>
                            </div>
                            <div class="invalid-feedback" id="rateError" style="display: none;">
                                Please enter a valid rate
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label" for="manualRateCurrency">
                                    Currency <span class="text-danger">*</span>
                                </label>
                                <select class="form-select" id="manualRateCurrency" 
                                        name="manual_rate_currency" required>
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($currency->code); ?>" 
                                                <?php echo e($currency->code === $baseCurrency ? 'selected' : ''); ?>>
                                            <?php echo e($currency->code); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label class="form-label" for="manualRateType">
                                    Rate Type <span class="text-danger">*</span>
                                </label>
                                <select class="form-select" id="manualRateType" 
                                        name="manual_rate_type" required>
                                    <option value="per_unit">Per Unit</option>
                                    <option value="flat_rate">Flat Rate</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="alert alert-info mt-3">
                            <i class="ri-information-line"></i> 
                            Manual rates override automatic calculations until reset
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-check-line"></i> Apply Rate
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- System Modals -->
    <div class="modal fade" id="systemAlertModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning">
                    <h5 class="modal-title"><i class="ri-alert-line me-2"></i> System Alert</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="systemAlertMessage">
                    <!-- Dynamic content will be inserted here -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

<?php $__env->startPush('styles'); ?>
<link href="<?php echo e(asset('css/shipment-form.css')); ?>" rel="stylesheet">
<style>
    .shipping-application {
        position: relative;
    }
    .system-status-bar {
        border-radius: 0.25rem;
    }
    .card-section .card-header {
        cursor: pointer;
        background-color: #f8f9fa;
    }
    .card-section .card-header button {
        text-decoration: none;
        color: inherit;
    }
    [data-currency-display] {
        min-width: 3.5rem;
    }
    .package-actions {
        white-space: nowrap;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<!-- Core Libraries -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" 
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" 
        crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js" 
        integrity="sha384-geWF76RCwLtnZ8qwWowPQNguL3RmwHVBC9FhGdlKrxdiJJigb/j/68SIy3Te4Bkz" 
        crossorigin="anonymous"></script>

<!-- Application Components -->
<script src="<?php echo e(asset('js/shipment/route-service.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/package-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/pricing-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/shipment-form-manager.js')); ?>"></script>

<!-- Initialization Script -->
<script>
// Error boundary for entire application
(function() {
    try {
        // Feature detection
        if (typeof Promise === 'undefined') {
            throw new Error('Promises not supported - please update your browser');
        }
        
        // Check required APIs
        if (!window.fetch || !window.Headers) {
            throw new Error('Modern browser features required');
        }
        
        // Initialize when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            try {
                // Create the application instance
                window.shipmentApp = new ShipmentFormManager({
                    debugMode: <?php echo e(config('app.debug') ? 'true' : 'false'); ?>

                });
                
                // Global error handler
                window.addEventListener('error', function(event) {
                    console.error('Global error:', event.error);
                    showApplicationError(event.error);
                });
                
                // Unhandled promise rejections
                window.addEventListener('unhandledrejection', function(event) {
                    console.error('Unhandled rejection:', event.reason);
                    showApplicationError(event.reason);
                });
            } catch (initError) {
                console.error('Initialization error:', initError);
                showApplicationError(initError);
            }
        });
        
        // Global error display function
        function showApplicationError(error) {
            const errorContainer = document.getElementById('globalErrorContainer') || 
                                 document.createElement('div');
            
            errorContainer.id = 'globalErrorContainer';
            errorContainer.className = 'global-error-container p-3 bg-danger text-white';
            errorContainer.innerHTML = `
                <h4>Application Error</h4>
                <p>${error.message || 'An unexpected error occurred'}</p>
                <button onclick="window.location.reload()" class="btn btn-light btn-sm">
                    Reload Application
                </button>
                <button onclick="this.parentElement.remove()" class="btn btn-outline-light btn-sm">
                    Dismiss
                </button>
            `;
            
            if (!document.getElementById('globalErrorContainer')) {
                document.body.prepend(errorContainer);
            }
        }
    } catch (criticalError) {
        // Fallback for catastrophic errors
        document.write(`
            <div style="padding: 20px; background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;">
                <h2>Critical System Error</h2>
                <p>${criticalError.message || 'The application cannot load'}</p>
                <p>Please try refreshing the page or contact support.</p>
            </div>
        `);
    }
})();
</script>
<?php $__env->stopPush(); ?>


<!-- Error Containers (add to your layout) -->
<div id="globalErrorContainer" class="d-none"></div>
<div id="systemErrorContainer" class="d-none"></div>

<!-- Toast Notification (add to your layout) -->
<div id="toastNotification" class="toast position-fixed bottom-0 end-0 m-3" role="alert">
    <div class="toast-header">
        <strong class="me-auto">Notification</strong>
        <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
    </div>
    <div class="toast-body"></div>
</div>
<?php /**PATH C:\MAMP\htdocs\smart-shipping\resources\views/shipments/form.blade.php ENDPATH**/ ?>