<div class="card mb-4 card-section">
    <div class="card-header">
        <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#verificationInfoCollapse" aria-expanded="false">
            <i class="ri-shield-check-line me-2"></i> 
            <span class="fw-semibold">Step 6: OTP Verification & Finalization</span>
            <span class="badge bg-secondary ms-2" id="verificationStepStatus">6</span>
        </button>
    </div>
    <div class="collapse" id="verificationInfoCollapse" data-bs-parent="#shipmentForm">
        <div class="card-body">
            <!-- OTP Verification Section -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <h6>Digital Signature (OTP Verification)</h6>
                    <div class="alert alert-info">
                        <i class="ri-information-line"></i> 
                        An OTP will be sent to the customer's phone for parcel drop-off verification
                    </div>
                    
                    <div class="mb-3">
                        <label for="otp_phone" class="form-label">Phone Number for OTP</label>
                        <input type="text" id="otp_phone" class="form-control" placeholder="Customer phone number" readonly>
                    </div>
                    
                    <button type="button" class="btn btn-outline-primary" id="sendOtpBtn" onclick="sendOTP()">
                        <i class="ri-send-plane-line"></i> Send OTP
                    </button>
                    
                    <div id="otpInputSection" class="mt-3 d-none">
                        <label for="otp_code" class="form-label">Enter OTP</label>
                        <div class="input-group">
                            <input type="text" id="otp_code" class="form-control" placeholder="Enter 6-digit OTP" maxlength="6">
                            <button type="button" class="btn btn-success" onclick="verifyOTP()">
                                <i class="ri-check-line"></i> Verify
                            </button>
                        </div>
                        <div id="otpStatus" class="mt-2"></div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <h6>WhatsApp Waybill Delivery</h6>
                    <div class="mb-3">
                        <label for="whatsapp_number" class="form-label">WhatsApp Number</label>
                        <input type="text" name="whatsapp_number" id="whatsapp_number" class="form-control" placeholder="Include country code">
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="send_whatsapp" id="send_whatsapp" checked>
                        <label class="form-check-label" for="send_whatsapp">
                            Send waybill and tracking link via WhatsApp
                        </label>
                    </div>
                </div>
            </div>

            <!-- Payment Section -->
            <div class="row">
                <div class="col-md-6">
                    <h6>Payment Method</h6>
                    <div class="payment-options d-flex gap-3 mb-3">
                        <div class="payment-option" data-payment="now">
                            <i class="ri-money-dollar-circle-line" style="font-size: 2rem;"></i>
                            <p>Pay Now</p>
                        </div>
                        <div class="payment-option" data-payment="delivery">
                            <i class="ri-truck-line" style="font-size: 2rem;"></i>
                            <p>Pay on Delivery</p>
                        </div>
                    </div>
                    
                    <div id="paymentDetails" class="mt-3 d-none">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="payment_method" class="form-label">Payment Method</label>
                                <select id="payment_method" name="payment_method" class="form-select">
                                    <option value="mpesa">M-Pesa</option>
                                    <option value="cash">Cash</option>
                                    <option value="card">Credit/Debit Card</option>
                                    <option value="bank_transfer">Bank Transfer</option>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="mpesa_number" class="form-label">M-Pesa Number</label>
                                <input type="text" id="mpesa_number" name="mpesa_number" class="form-control" placeholder="07XXXXXXXX">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="summary-section">
                        <h6>Shipment Summary</h6>
                        <p><strong>Total Amount:</strong> <span id="finalAmountDisplay">0.00</span> <?php echo e($baseCurrency); ?></p>
                        <p><strong>My Profit:</strong> <span id="finalProfitDisplay">0.00</span> <?php echo e($baseCurrency); ?></p>
                        <p><strong>Tracking Number:</strong> <span id="finalTrackingDisplay">Not generated</span></p>
                        <p><strong>Service Provider:</strong> <span id="finalProviderDisplay">-</span></p>
                        <p><strong>Payment Status:</strong> <span id="paymentStatusDisplay" class="badge bg-warning">Pending</span></p>
                        <p><strong>OTP Status:</strong> <span id="otpStatusDisplay" class="badge bg-danger">Not Verified</span></p>
                    </div>
                </div>
            </div>

            <!-- Final Actions -->
            <div class="mt-4 border-top pt-3">
                <div class="d-flex justify-content-between">
                    <button type="button" class="btn btn-outline-secondary" onclick="saveAsDraft()">
                        <i class="ri-save-line"></i> Save as Draft
                    </button>
                    
                    <div>
                        <button type="button" class="btn btn-outline-primary me-2" onclick="generateWaybillPreview()">
                            <i class="ri-barcode-line"></i> Preview Waybill
                        </button>
                        <button type="submit" class="btn btn-success" id="finalSubmitBtn" disabled>
                            <i class="ri-check-double-line"></i> Complete Shipment Booking
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipments/partials/verification-payment.blade.php ENDPATH**/ ?>