<?php
use App\Models\Currency;
$baseCurrency = Currency::base()->code;
$currencies = Currency::all();
?>

<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'action' => '#',
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'action' => '#',
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]); ?>
<?php foreach (array_filter(([
    'action' => '#',
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="shipping-application">
    <!-- System Status Bar -->
    <div class="system-status-bar alert alert-info d-flex align-items-center mb-4">
        <i class="ri-information-line me-2"></i>
        <span id="systemStatus">Ready to create new shipment</span>
        <div class="ms-auto">
            <span class="badge bg-primary" id="formStepIndicator">Step 1 of 5</span>
        </div>
    </div>

<form id="shipmentForm" method="POST" action="<?php echo e($action); ?>" class="card p-4" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php if($method !== 'POST'): ?>
        <?php echo method_field($method); ?>
    <?php endif; ?>

    <!-- Currency Handling Fields -->
    <input type="hidden" name="base_currency" value="<?php echo e($baseCurrency); ?>">
    <input type="hidden" name="original_currency" id="originalCurrency" value="<?php echo e($baseCurrency); ?>">
    <input type="hidden" name="exchange_rate" id="exchangeRate" value="1">
    <input type="hidden" name="shipment_status" id="shipmentStatus" value="draft">

    <!-- Step 1: Customer Information Accordion -->
    <div class="card mb-4 card-section">
        <div class="card-header">
            <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#customerInfoCollapse" aria-expanded="true">
                <i class="ri-user-line me-2"></i> 
                <span class="fw-semibold">Step 1: Customer Information</span>
                <span class="badge bg-success ms-2" id="customerStepStatus">✓</span>
            </button>
        </div>
        <div class="collapse show" id="customerInfoCollapse" data-bs-parent="#shipmentForm">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="customer_id" class="form-label required-field">Select Customer</label>
                        <select class="form-select" id="customer_id" name="customer_id" required>
                            <option value="">Choose existing customer...</option>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($customer->id); ?>" 
                                    <?php echo e($shipment && $shipment->customer_id == $customer->id ? 'selected' : ''); ?>>
                                    <?php echo e($customer->name); ?> - <?php echo e($customer->phone); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Or Create New Customer</label>
                        <button type="button" class="btn btn-outline-primary w-100" data-bs-toggle="modal" data-bs-target="#newCustomerModal">
                            <i class="ri-user-add-line"></i> Add New Customer
                        </button>
                    </div>
                </div>

                <!-- Customer Details (auto-populated when customer selected) -->
                <div id="customerDetails" class="d-none">
                    <div class="row">
                        <div class="col-md-4">
                            <strong>Name:</strong> <span id="customerNameDisplay"></span>
                        </div>
                        <div class="col-md-4">
                            <strong>Phone:</strong> <span id="customerPhoneDisplay"></span>
                        </div>
                        <div class="col-md-4">
                            <strong>ID:</strong> <span id="customerIdDisplay"></span>
                        </div>
                    </div>
                </div>

                <!-- Sending on Behalf Section -->
                <div class="form-check mt-3 mb-3">
                    <input class="form-check-input" type="checkbox" id="sendingOnBehalf" name="sending_on_behalf">
                    <label class="form-check-label" for="sendingOnBehalf">
                        Sending on behalf of someone else
                    </label>
                </div>

                <div id="senderInfoSection" class="d-none mt-3 p-3 border rounded">
                    <h6>Sender Information</h6>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="sender_name" class="form-label">Sender Name</label>
                            <input type="text" class="form-control" id="sender_name" name="sender_name">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="sender_phone" class="form-label">Sender Phone</label>
                            <input type="text" class="form-control" id="sender_phone" name="sender_phone">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="sender_id_number" class="form-label">Sender ID Number</label>
                            <input type="text" class="form-control" id="sender_id_number" name="sender_id_number">
                        </div>
                    </div>
                </div>

                <div class="mt-3">
                    <button type="button" class="btn btn-success" onclick="validateCustomerSection()">
                        <i class="ri-check-line"></i> Confirm Customer Details
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Step 2: Package Details Accordion -->
    <div class="card mb-4 card-section">
        <div class="card-header">
            <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#packageInfoCollapse" aria-expanded="false">
                <i class="ri-package-line me-2"></i> 
                <span class="fw-semibold">Step 2: Package Details</span>
                <span class="badge bg-secondary ms-2" id="packageStepStatus">2</span>
            </button>
        </div>
        <div class="collapse" id="packageInfoCollapse" data-bs-parent="#shipmentForm">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="numPieces" class="form-label required-field">Number of Packages/Pieces</label>
                        <input type="number" id="numPieces" class="form-control" name="num_pieces" 
                               min="1" max="50" placeholder="e.g., 3" required>
                    </div>
                    <div class="col-md-8 mb-3">
                        <div class="alert alert-info">
                            <i class="ri-information-line"></i> 
                            Enter the total number of packages. The system will generate individual forms for each package.
                        </div>
                    </div>
                </div>

                <!-- Dynamic Package Forms Container -->
                <div id="packageFormsContainer" class="package-details-section">
                    <!-- Package forms will be generated here dynamically -->
                </div>

                <!-- Package Summary -->
                <div id="packageSummary" class="summary-section d-none mt-4">
                    <h6>Package Summary</h6>
                    <div class="row">
                        <div class="col-md-3">
                            <strong>Total Packages:</strong> <span id="totalPackagesCount">0</span>
                        </div>
                        <div class="col-md-3">
                            <strong>Total Weight:</strong> <span id="totalWeightDisplay">0</span> kg
                        </div>
                        <div class="col-md-3">
                            <strong>Total Volume:</strong> <span id="totalVolumeDisplay">0</span> m³
                        </div>
                    </div>
                </div>

                <div class="mt-3">
                    <button type="button" class="btn btn-success" onclick="validatePackagesSection()">
                        <i class="ri-check-line"></i> Confirm Package Details
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Step 3: Shipment Details Accordion -->
    <div class="card mb-4 card-section">
        <div class="card-header">
            <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#shipmentInfoCollapse" aria-expanded="false">
                <i class="ri-ship-line me-2"></i> 
                <span class="fw-semibold">Step 3: Shipment Details</span>
                <span class="badge bg-secondary ms-2" id="shipmentStepStatus">3</span>
            </button>
        </div>
        <div class="collapse" id="shipmentInfoCollapse" data-bs-parent="#shipmentForm">
            <div class="card-body">
                <!-- Package Summary Display -->
                <div id="shipmentSummary" class="summary-section mb-4">
                    <p><strong>Package Summary:</strong> <span id="summaryPackages">0</span> packages, Total Weight: <span id="summaryWeight">0</span> kgs</p>
                </div>

                <!-- Route Details -->
                <?php echo $__env->make('shipments.partials.route-details', [
                    'countries' => $countries,
                    'shipmentModes' => $shipmentModes,
                    'cargoCategories' => $cargoCategories,
                    'shipment' => $shipment
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <!-- Automatic Tracking Number Generation -->
                <div class="row mt-3">
                    <div class="col-md-6 mb-3">
                        <label for="tracking_number" class="form-label">Tracking Number</label>
                        <div class="input-group">
                            <input type="text" id="tracking_number" name="tracking_number" 
                                   class="form-control readonly-field" readonly>
                            <button type="button" class="btn btn-outline-secondary" id="generateTrackingBtn">
                                <i class="ri-refresh-line"></i> Generate
                            </button>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="shipment_reference" class="form-label">Shipment Reference</label>
                        <input type="text" id="shipment_reference" name="shipment_reference" 
                               class="form-control" placeholder="Optional reference">
                    </div>
                </div>

                <!-- Shipping Rates Section -->
                <div class="accordion mt-4" id="ratesAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ratesInfo" aria-expanded="false">
                                <i class="ri-money-dollar-circle-line me-2"></i> Shipping Rates & Billing
                            </button>
                        </h2>
                        <div id="ratesInfo" class="accordion-collapse collapse">
                            <div class="accordion-body">
                                <div class="rate-info mb-3">
                                    <p><strong>Available Rates:</strong> Based on your selected route and shipment details</p>
                                    <div id="availableRates" class="mt-2">
                                        <!-- Rates will be populated here -->
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="billing_currency" class="form-label required-field">Billing Currency</label>
                                        <select id="billing_currency" name="billing_currency" class="form-select" required>
                                            <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($currency->code); ?>" 
                                                    <?php echo e($currency->code === $baseCurrency ? 'selected' : ''); ?>>
                                                    <?php echo e($currency->code); ?> - <?php echo e($currency->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="manual_rate" class="form-label">Manual Rate Override</label>
                                        <button type="button" class="btn btn-outline-warning w-100" data-bs-toggle="modal" data-bs-target="#manualRateModal">
                                            <i class="ri-edit-line"></i> Set Manual Rate
                                        </button>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="billing_rate" class="form-label">Calculated Rate</label>
                                        <input type="text" id="billing_rate" name="billing_rate" 
                                               class="form-control readonly-field" readonly>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="billing_amount" class="form-label">Total Amount</label>
                                        <input type="text" id="billing_amount" name="billing_amount" 
                                               class="form-control readonly-field" readonly>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="final_amount" class="form-label">Final Amount (<?php echo e($baseCurrency); ?>)</label>
                                        <input type="text" id="final_amount" name="final_amount" 
                                               class="form-control readonly-field bg-light" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-3">
                    <button type="button" class="btn btn-success" onclick="validateShipmentSection()">
                        <i class="ri-check-line"></i> Confirm Shipment Details
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Step 4: Extra Services Accordion -->
    <div class="card mb-4 card-section">
        <div class="card-header">
            <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#servicesInfoCollapse" aria-expanded="false">
                <i class="ri-service-line me-2"></i> 
                <span class="fw-semibold">Step 4: Extra Services</span>
                <span class="badge bg-secondary ms-2" id="servicesStepStatus">4</span>
            </button>
        </div>
        <div class="collapse" id="servicesInfoCollapse" data-bs-parent="#shipmentForm">
            <div class="card-body">
                <?php echo $__env->make('shipments.partials.services', [
                    'services' => $services,
                    'currencies' => $currencies,
                    'selectedServices' => $shipment->services ?? []
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="mt-3">
                    <button type="button" class="btn btn-success" onclick="validateServicesSection()">
                        <i class="ri-check-line"></i> Confirm Services
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Step 5: Payment & Finalization Accordion -->
    <div class="card mb-4 card-section">
        <div class="card-header">
            <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#paymentInfoCollapse" aria-expanded="false">
                <i class="ri-bank-card-line me-2"></i> 
                <span class="fw-semibold">Step 5: Payment & Finalization</span>
                <span class="badge bg-secondary ms-2" id="paymentStepStatus">5</span>
            </button>
        </div>
        <div class="collapse" id="paymentInfoCollapse" data-bs-parent="#shipmentForm">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Payment Method</h6>
                        <div class="payment-options">
                            <div class="payment-option" data-payment="now">
                                <i class="ri-money-dollar-circle-line" style="font-size: 2rem;"></i>
                                <p>Pay Now</p>
                            </div>
                            <div class="payment-option" data-payment="delivery">
                                <i class="ri-truck-line" style="font-size: 2rem;"></i>
                                <p>Pay on Delivery</p>
                            </div>
                        </div>
                        
                        <div id="paymentDetails" class="mt-3 d-none">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="payment_method" class="form-label">Payment Method</label>
                                    <select id="payment_method" name="payment_method" class="form-select">
                                        <option value="mpesa">M-Pesa</option>
                                        <option value="cash">Cash</option>
                                        <option value="card">Credit/Debit Card</option>
                                        <option value="bank_transfer">Bank Transfer</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="mpesa_number" class="form-label">M-Pesa Number</label>
                                    <input type="text" id="mpesa_number" name="mpesa_number" class="form-control" placeholder="07XXXXXXXX">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="summary-section">
                            <h6>Shipment Summary</h6>
                            <p><strong>Total Amount:</strong> <span id="finalAmountDisplay">0.00</span> <?php echo e($baseCurrency); ?></p>
                            <p><strong>Tracking Number:</strong> <span id="finalTrackingDisplay">Not generated</span></p>
                            <p><strong>Estimated Delivery:</strong> <span id="finalEtaDisplay">-</span></p>
                            <p><strong>Payment Status:</strong> <span id="paymentStatusDisplay" class="badge bg-warning">Pending</span></p>
                        </div>
                    </div>
                </div>

                <!-- Final Actions -->
                <div class="mt-4 border-top pt-3">
                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-outline-secondary" onclick="saveAsDraft()">
                            <i class="ri-save-line"></i> Save as Draft
                        </button>
                        
                        <div>
                            <button type="button" class="btn btn-outline-primary me-2" onclick="generateWaybillPreview()">
                                <i class="ri-barcode-line"></i> Preview Waybill
                            </button>
                            <button type="submit" class="btn btn-success" id="finalSubmitBtn">
                                <i class="ri-check-double-line"></i> Complete Shipment Booking
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<!-- New Customer Modal -->
<div class="modal fade" id="newCustomerModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Customer</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Customer form fields -->
                <div class="mb-3">
                    <label class="form-label">Customer Name</label>
                    <input type="text" class="form-control" id="new_customer_name">
                </div>
                <div class="mb-3">
                    <label class="form-label">Phone Number</label>
                    <input type="text" class="form-control" id="new_customer_phone">
                </div>
                <div class="mb-3">
                    <label class="form-label">ID Number</label>
                    <input type="text" class="form-control" id="new_customer_id">
                </div>
                <div class="mb-3">
                    <label class="form-label">Email (Optional)</label>
                    <input type="email" class="form-control" id="new_customer_email">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="saveNewCustomer()">Save Customer</button>
            </div>
        </div>
    </div>
</div>

<!-- Manual Rate Modal (keep your existing modal) -->
<div class="modal fade" id="manualRateModal" tabindex="-1" aria-hidden="true">
    <!-- Your existing manual rate modal content -->
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .card-section {
        margin-bottom: 1.5rem;
        border: 1px solid #e9ecef;
        border-radius: 0.5rem;
    }
    .card-section .card-header {
        background-color: #f8f9fa;
        padding: 1rem 1.25rem;
    }
    .card-section .card-header button {
        font-weight: 600;
        color: #495057;
    }
    .required-field::after {
        content: " *";
        color: #dc3545;
    }
    .summary-section {
        background-color: #f8f9fa;
        padding: 1rem;
        border-radius: 0.5rem;
    }
    .payment-option {
        flex: 1;
        text-align: center;
        padding: 1rem;
        border: 2px solid #dee2e6;
        border-radius: 0.5rem;
        cursor: pointer;
        transition: all 0.3s;
    }
    .payment-option:hover, .payment-option.active {
        background-color: #e7f1ff;
        border-color: #0c63e4;
    }
    .package-accordion {
        margin-bottom: 1rem;
    }
    .readonly-field {
        background-color: #f8f9fa;
    }
    .step-completed .card-header {
        background-color: #d1e7dd;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Global variables
let currentStep = 1;
let packageCount = 0;
let totalWeight = 0;

// Initialize form
document.addEventListener('DOMContentLoaded', function() {
    initializeForm();
    generateTrackingNumber();
});

function initializeForm() {
    // Event listeners
    document.getElementById('customer_id').addEventListener('change', loadCustomerDetails);
    document.getElementById('sendingOnBehalf').addEventListener('change', toggleSenderInfo);
    document.getElementById('numPieces').addEventListener('change', generatePackageForms);
    document.getElementById('generateTrackingBtn').addEventListener('click', generateTrackingNumber);
    
    // Payment option selection
    document.querySelectorAll('.payment-option').forEach(option => {
        option.addEventListener('click', selectPaymentOption);
    });
    
    // Form step navigation
    setupStepNavigation();
}

function setupStepNavigation() {
    const accordions = document.querySelectorAll('.card-section .card-header button');
    accordions.forEach((accordion, index) => {
        accordion.addEventListener('click', function() {
            currentStep = index + 1;
            updateStepIndicator();
        });
    });
}

function updateStepIndicator() {
    document.getElementById('formStepIndicator').textContent = `Step ${currentStep} of 5`;
    
    // Update status badges
    for (let i = 1; i <= 5; i++) {
        const statusBadge = document.getElementById(`${getStepName(i)}StepStatus`);
        if (i < currentStep) {
            statusBadge.className = 'badge bg-success ms-2';
            statusBadge.textContent = '✓';
        } else if (i === currentStep) {
            statusBadge.className = 'badge bg-primary ms-2';
            statusBadge.textContent = i;
        } else {
            statusBadge.className = 'badge bg-secondary ms-2';
            statusBadge.textContent = i;
        }
    }
}

function getStepName(step) {
    const steps = ['customer', 'package', 'shipment', 'services', 'payment'];
    return steps[step - 1] || '';
}

// Customer section functions
function loadCustomerDetails() {
    const customerId = this.value;
    if (customerId) {
        // AJAX call to get customer details
        fetch(`/api/customers/${customerId}`)
            .then(response => response.json())
            .then(customer => {
                document.getElementById('customerNameDisplay').textContent = customer.name;
                document.getElementById('customerPhoneDisplay').textContent = customer.phone;
                document.getElementById('customerIdDisplay').textContent = customer.id_number;
                document.getElementById('customerDetails').classList.remove('d-none');
            });
    } else {
        document.getElementById('customerDetails').classList.add('d-none');
    }
}

function toggleSenderInfo() {
    const senderSection = document.getElementById('senderInfoSection');
    if (this.checked) {
        senderSection.classList.remove('d-none');
    } else {
        senderSection.classList.add('d-none');
    }
}

function validateCustomerSection() {
    // Validation logic
    const customerId = document.getElementById('customer_id').value;
    if (!customerId) {
        showError('Please select or create a customer');
        return;
    }
    
    // Mark as completed and move to next step
    document.getElementById('customerInfoCollapse').classList.remove('show');
    document.getElementById('packageInfoCollapse').classList.add('show');
    currentStep = 2;
    updateStepIndicator();
}

// Package section functions
function generatePackageForms() {
    const numPieces = parseInt(this.value);
    const container = document.getElementById('packageFormsContainer');
    const summary = document.getElementById('packageSummary');
    
    container.innerHTML = '';
    packageCount = numPieces;
    totalWeight = 0;
    
    if (numPieces > 0) {
        for (let i = 1; i <= numPieces; i++) {
            const packageHtml = `
                <div class="accordion package-accordion" id="packageAccordion${i}">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#packageCollapse${i}">
                                Package ${i}
                            </button>
                        </h2>
                        <div id="packageCollapse${i}" class="accordion-collapse collapse">
                            <div class="accordion-body">
                                <div class="row">
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Length (cm)</label>
                                        <input type="number" class="form-control package-dimension" data-package="${i}" data-dimension="length" name="packages[${i}][length]">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Width (cm)</label>
                                        <input type="number" class="form-control package-dimension" data-package="${i}" data-dimension="width" name="packages[${i}][width]">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Height (cm)</label>
                                        <input type="number" class="form-control package-dimension" data-package="${i}" data-dimension="height" name="packages[${i}][height]">
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">Weight (kg)</label>
                                        <input type="number" class="form-control package-weight" data-package="${i}" name="packages[${i}][weight]" step="0.1">
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Contents Description</label>
                                    <textarea class="form-control" name="packages[${i}][contents]" rows="3" placeholder="Describe the contents of this package"></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Upload Images (Max 3)</label>
                                    <input type="file" class="form-control" name="packages[${i}][images][]" multiple accept="image/*">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            container.innerHTML += packageHtml;
        }
        
        summary.classList.remove('d-none');
        updatePackageSummary();
        
        // Add event listeners for dynamic fields
        document.querySelectorAll('.package-weight').forEach(input => {
            input.addEventListener('change', updatePackageSummary);
        });
    } else {
        summary.classList.add('d-none');
    }
}

function updatePackageSummary() {
    let totalWeight = 0;
    let totalVolume = 0;
    
    document.querySelectorAll('.package-weight').forEach(input => {
        if (input.value) {
            totalWeight += parseFloat(input.value);
        }
    });
    
    document.getElementById('totalPackagesCount').textContent = packageCount;
    document.getElementById('totalWeightDisplay').textContent = totalWeight.toFixed(2);
    document.getElementById('totalVolumeDisplay').textContent = totalVolume.toFixed(3);
    
    // Update shipment summary
    document.getElementById('summaryPackages').textContent = packageCount;
    document.getElementById('summaryWeight').textContent = totalWeight.toFixed(2);
}

function validatePackagesSection() {
    if (packageCount === 0) {
        showError('Please enter the number of packages');
        return;
    }
    
    // Move to next step
    document.getElementById('packageInfoCollapse').classList.remove('show');
    document.getElementById('shipmentInfoCollapse').classList.add('show');
    currentStep = 3;
    updateStepIndicator();
}

// Tracking number generation
function generateTrackingNumber() {
    const prefix = 'TRK';
    const randomNum = Math.floor(100000 + Math.random() * 900000);
    const trackingNumber = `${prefix}${randomNum}`;
    
    document.getElementById('tracking_number').value = trackingNumber;
    document.getElementById('finalTrackingDisplay').textContent = trackingNumber;
}

// Payment section functions
function selectPaymentOption(event) {
    document.querySelectorAll('.payment-option').forEach(opt => opt.classList.remove('active'));
    event.currentTarget.classList.add('active');
    
    const paymentType = event.currentTarget.dataset.payment;
    const paymentDetails = document.getElementById('paymentDetails');
    
    if (paymentType === 'now') {
        paymentDetails.classList.remove('d-none');
    } else {
        paymentDetails.classList.add('d-none');
    }
}

// Final submission
function saveAsDraft() {
    document.getElementById('shipmentStatus').value = 'draft';
    document.getElementById('shipmentForm').submit();
}

function generateWaybillPreview() {
    // Generate waybill preview logic
    alert('Waybill preview functionality would be implemented here');
}

// Utility functions
function showError(message) {
    // Show error using your preferred method (toast, alert, etc.)
    console.error('Error:', message);
}

function showSuccess(message) {
    // Show success message
    console.log('Success:', message);
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\resources\views/shipments/form.blade.php ENDPATH**/ ?>