<div class="modal fade" id="routeModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Route</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="routeForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Route Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="route_name" required placeholder="Enter route name">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Shipping Method <span class="text-danger">*</span></label>
                                <select class="form-select" name="shipping_method" required>
                                    <option value="air">Air Freight</option>
                                    <option value="sea">Sea Freight</option>
                                    <option value="land" selected>Land Transport</option>
                                    <option value="rail">Rail</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Origin <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="origin" required placeholder="Enter origin">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Destination <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="destination" required placeholder="Enter destination">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Minimum Chargeable <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" class="form-control" name="minimum_chargeable" required placeholder="0.00">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Volumetric Divisor <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" class="form-control" name="volumetric_divisor" value="5000" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Transit Days</label>
                                <input type="number" class="form-control" name="transit_days" placeholder="Enter transit days">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Chargeable Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="chargeable_type" required>
                                    <option value="volumetric_weight">Volumetric Weight</option>
                                    <option value="gross_weight">Gross Weight</option>
                                    <option value="net_volume">Net Volume</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Rate per KG</label>
                                <input type="number" step="0.01" class="form-control" name="rate_per_kg" placeholder="0.00">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Weight Bands</label>
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered">
                                <thead>
                                    <tr>
                                        <th>Min Weight (kg)</th>
                                        <th>Max Weight (kg)</th>
                                        <th>Rate (per kg)</th>
                                    </tr>
                                </thead>
                                <tbody id="weightBandsTable">
                                    <tr>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[0][min]" value="0" step="0.01"></td>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[0][max]" value="25" step="0.01"></td>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[0][rate]" value="0" step="0.01"></td>
                                    </tr>
                                    <tr>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[1][min]" value="25" step="0.01"></td>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[1][max]" value="50" step="0.01"></td>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[1][rate]" value="0" step="0.01"></td>
                                    </tr>
                                    <tr>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[2][min]" value="50" step="0.01"></td>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[2][max]" value="100" step="0.01"></td>
                                        <td><input type="number" class="form-control form-control-sm" name="weight_bands[2][rate]" value="0" step="0.01"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <button type="button" class="btn btn-sm btn-outline-primary" id="addWeightBand">
                            <i class="ri-add-line"></i> Add Weight Band
                        </button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Route</button>
                </div>
            </form>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/vendor/service-providers/partials/modals/route-modal.blade.php ENDPATH**/ ?>