<div class="card mb-4 card-section">
    <div class="card-header">
        <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#customerInfoCollapse" aria-expanded="true">
            <i class="ri-user-line me-2"></i> 
            <span class="fw-semibold">Step 1: Customer Information</span>
            <span class="badge bg-success ms-2" id="customerStepStatus">✓</span>
        </button>
    </div>
    <div class="collapse show" id="customerInfoCollapse" data-bs-parent="#shipmentForm">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="customer_id" class="form-label required-field">Select Customer</label>
                    <select class="form-select" id="customer_id" name="customer_id" required>
                        <option value="">Choose existing customer...</option>
                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($customer->id); ?>" 
                                <?php echo e($shipment && $shipment->customer_id == $customer->id ? 'selected' : ''); ?>

                                data-phone="<?php echo e($customer->phone); ?>"
                                data-email="<?php echo e($customer->email ?? ''); ?>">
                                <?php echo e($customer->name); ?> - <?php echo e($customer->phone); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Or Create New Customer</label>
                    <button type="button" class="btn btn-outline-primary w-100" data-bs-toggle="modal" data-bs-target="#newCustomerModal">
                        <i class="ri-user-add-line"></i> Add New Customer
                    </button>
                </div>
            </div>

            <!-- Customer Details -->
            <div id="customerDetails" class="d-none">
                <div class="row">
                    <div class="col-md-4"><strong>Name:</strong> <span id="customerNameDisplay"></span></div>
                    <div class="col-md-4"><strong>Phone:</strong> <span id="customerPhoneDisplay"></span></div>
                    <div class="col-md-4"><strong>Email:</strong> <span id="customerEmailDisplay"></span></div>
                </div>
            </div>

            <!-- Sending on Behalf Section -->
            <div class="form-check mt-3 mb-3">
                <input class="form-check-input" type="checkbox" id="sendingOnBehalf" name="sending_on_behalf">
                <label class="form-check-label" for="sendingOnBehalf">Sending on behalf of someone else</label>
            </div>

            <div id="senderInfoSection" class="d-none mt-3 p-3 border rounded">
                <h6>Sender Information</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="sender_name" class="form-label">Sender Name</label>
                        <input type="text" class="form-control" id="sender_name" name="sender_name">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="sender_phone" class="form-label">Sender Phone</label>
                        <input type="text" class="form-control" id="sender_phone" name="sender_phone">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="sender_id_number" class="form-label">Sender ID Number</label>
                        <input type="text" class="form-control" id="sender_id_number" name="sender_id_number">
                    </div>
                </div>
            </div>

            <div class="mt-3">
                <button type="button" class="btn btn-success" onclick="validateCustomerSection()">
                    <i class="ri-check-line"></i> Confirm Customer Details
                </button>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipments/partials/customer-info.blade.php ENDPATH**/ ?>