<?php

use App\Http\Controllers\Vendors\ServiceProviderController;
use App\Http\Controllers\Vendors\SupplierPaymentController;
use App\Http\Controllers\Vendors\ServiceProviderReportController;

Route::middleware(['auth'])->group(function () {
    // Service Providers Routes (Vendors)
    Route::resource('service-providers', ServiceProviderController::class);
    
    // Service Provider additional routes
    Route::prefix('service-providers')->group(function () {
        // Create with type parameter
        Route::get('/create/{type}', [ServiceProviderController::class, 'create'])
            ->name('service-providers.create.type')
            ->where('type', 'service_provider|supplier');
        
        // Toggle status
        Route::post('/{serviceProvider}/toggle-status', [ServiceProviderController::class, 'toggleStatus'])
            ->name('service-providers.toggle-status');
        
        // Routes management
        Route::post('/{serviceProvider}/routes', [ServiceProviderController::class, 'storeRoute'])
            ->name('service-providers.routes.store');
        
        Route::put('/routes/{route}', [ServiceProviderController::class, 'updateRoute'])
            ->name('service-providers.routes.update');
        
        Route::delete('/routes/{route}', [ServiceProviderController::class, 'destroyRoute'])
            ->name('service-providers.routes.destroy');
        
        // Weight bands management
        Route::post('/routes/{route}/weight-bands', [ServiceProviderController::class, 'storeWeightBand'])
            ->name('service-providers.weight-bands.store');
        
        Route::put('/weight-bands/{weightBand}', [ServiceProviderController::class, 'updateWeightBand'])
            ->name('service-providers.weight-bands.update');
        
        Route::delete('/weight-bands/{weightBand}', [ServiceProviderController::class, 'destroyWeightBand'])
            ->name('service-providers.weight-bands.destroy');

        // Supplier Payments
        Route::get('/{serviceProvider}/payments', [ServiceProviderController::class, 'paymentIndex'])
            ->name('service-providers.payments.index');
        
        Route::post('/{serviceProvider}/payments', [ServiceProviderController::class, 'paymentStore'])
            ->name('service-providers.payments.store');
        
        Route::get('/{serviceProvider}/payments/create', [ServiceProviderController::class, 'paymentCreate'])
            ->name('service-providers.payments.create');
        
        Route::get('/{serviceProvider}/payments/{payment}', [ServiceProviderController::class, 'paymentShow'])
            ->name('service-providers.payments.show');

        // Summary and Reports
        Route::get('/{serviceProvider}/summary', [ServiceProviderController::class, 'summary'])
            ->name('service-providers.summary');
        
        Route::get('/{serviceProvider}/generate-summary', [ServiceProviderController::class, 'generateSummary'])
            ->name('service-providers.generate-summary');
        
        // API endpoints
        Route::get('/api/search', [ServiceProviderController::class, 'search'])
            ->name('service-providers.search');
        
        Route::get('/api/{serviceProvider}/routes', [ServiceProviderController::class, 'getRoutes'])
            ->name('service-providers.routes.get');
        
        Route::post('/api/calculate-rates', [ServiceProviderController::class, 'calculateRates'])
            ->name('service-providers.calculate-rates');
    });

    // Supplier Payments (standalone)
    Route::resource('supplier-payments', SupplierPaymentController::class)->except(['create', 'store']);
    
    // Supplier Payments additional routes
    Route::prefix('supplier-payments')->group(function () {
        Route::post('/export', [SupplierPaymentController::class, 'export'])
            ->name('supplier-payments.export');
    });

    // Service Provider Reports
    Route::prefix('reports')->group(function () {
        Route::get('/service-providers', [ServiceProviderReportController::class, 'index'])
            ->name('reports.service-providers.index');
        
        Route::get('/service-providers/generate', [ServiceProviderReportController::class, 'generate'])
            ->name('reports.service-providers.generate');
        
        Route::get('/supplier-payments', [ServiceProviderReportController::class, 'payments'])
            ->name('reports.supplier-payments');
        
        Route::get('/route-performance', [ServiceProviderReportController::class, 'routePerformance'])
            ->name('reports.route-performance');
    });
});