<?php

use App\Http\Controllers\ServiceController;
use App\Http\Controllers\CustomerController;

Route::middleware(['auth'])->group(function () {
    // Services
    Route::resource('services', ServiceController::class);
    Route::get('/api/services/pricing', [ServiceController::class, 'getPricing'])
        ->name('services.pricing');

    // Customers
    Route::resource('customers', CustomerController::class);
    Route::get('/api/customers/search', [CustomerController::class, 'search'])
        ->name('customers.search');
});