<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-centered table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Vendor Code</th>
                                <th>Supplier Name</th>
                                <th>Type</th>
                                <th>Onboarding Date</th>
                                <th>Open Balance</th>
                                <th>Status</th>
                                <th width="100px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($suppliers as $supplier)
                                <tr data-vendor-id="{{ $supplier->id }}" data-vendor-type="supplier" data-status="{{ $supplier->status }}">
                                    <td>
                                        <span class="badge bg-warning text-dark">{{ $supplier->vendor_code }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <img src="https://ui-avatars.com/api/?name={{ urlencode($supplier->name) }}&background=f1b44c&color=fff" 
                                                     alt="logo" class="rounded-circle" width="40">
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <h6 class="mb-0">{{ $supplier->name }}</h6>
                                                <small class="text-muted">{{ $supplier->email }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ ucfirst($supplier->type) }}</span>
                                    </td>
                                    <td>{{ $supplier->onboarding_date->format('M d, Y') }}</td>
                                    <td>
                                        <span class="fw-bold {{ $supplier->open_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                            KES {{ number_format($supplier->open_balance, 2) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge {{ $supplier->status === 'active' ? 'bg-success' : 'bg-danger' }}">
                                            {{ ucfirst($supplier->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button type="button" class="btn btn-outline-primary" 
                                                    data-action="view" data-vendor-id="{{ $supplier->id }}"
                                                    title="View Details">
                                                <i class="ri-eye-line"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-success"
                                                    data-action="payment" data-vendor-id="{{ $supplier->id }}"
                                                    title="Make Payment">
                                                <i class="ri-money-dollar-circle-line"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-info"
                                                    data-action="summary" data-vendor-id="{{ $supplier->id }}"
                                                    title="Generate Summary">
                                                <i class="ri-file-list-3-line"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="row mt-3">
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_info">
                            Showing {{ $suppliers->firstItem() }} to {{ $suppliers->lastItem() }} of {{ $suppliers->total() }} entries
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers float-end">
                            {{ $suppliers->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>