<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-centered table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Vendor Code</th>
                                <th>Service Provider</th>
                                <th>Type</th>
                                <th>Onboarding Date</th>
                                <th>Open Balance</th>
                                <th>Routes</th>
                                <th>Status</th>
                                <th width="120px">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($serviceProviders as $provider)
                                <tr data-vendor-id="{{ $provider->id }}" data-vendor-type="service-provider" data-status="{{ $provider->status }}">
                                    <td>
                                        <span class="badge bg-primary">{{ $provider->vendor_code }}</span>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <img src="https://ui-avatars.com/api/?name={{ urlencode($provider->name) }}&background=4a81d4&color=fff" 
                                                     alt="logo" class="rounded-circle" width="40">
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <h6 class="mb-0">{{ $provider->name }}</h6>
                                                <small class="text-muted">{{ $provider->email }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($provider->is_default)
                                            <span class="badge bg-success">Default (Inhouse)</span>
                                        @else
                                            <span class="badge bg-info">{{ ucfirst($provider->type) }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $provider->onboarding_date->format('M d, Y') }}</td>
                                    <td>
                                        <span class="fw-bold {{ $provider->open_balance >= 0 ? 'text-success' : 'text-danger' }}">
                                            KES {{ number_format($provider->open_balance, 2) }}
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $provider->routes_count ?? 0 }} routes</span>
                                    </td>
                                    <td>
                                        <span class="badge {{ $provider->status === 'active' ? 'bg-success' : 'bg-danger' }}">
                                            {{ ucfirst($provider->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button type="button" class="btn btn-outline-primary" 
                                                    data-action="view" data-vendor-id="{{ $provider->id }}"
                                                    title="View Details">
                                                <i class="ri-eye-line"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-success"
                                                    data-action="payment" data-vendor-id="{{ $provider->id }}"
                                                    title="Make Payment">
                                                <i class="ri-money-dollar-circle-line"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-info"
                                                    data-action="summary" data-vendor-id="{{ $provider->id }}"
                                                    title="Generate Summary">
                                                <i class="ri-file-list-3-line"></i>
                                            </button>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <button type="button" class="btn btn-outline-warning dropdown-toggle" 
                                                        data-bs-toggle="dropdown" title="More Actions">
                                                    <i class="ri-more-2-fill"></i>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-action="edit" data-vendor-id="{{ $provider->id }}">
                                                            <i class="ri-edit-line me-1"></i> Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-action="routes" data-vendor-id="{{ $provider->id }}">
                                                            <i class="ri-route-line me-1"></i> Manage Routes
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" 
                                                           data-action="toggle-status" data-vendor-id="{{ $provider->id }}">
                                                            <i class="ri-toggle-line me-1"></i> Toggle Status
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#" 
                                                           data-action="delete" data-vendor-id="{{ $provider->id }}">
                                                            <i class="ri-delete-bin-line me-1"></i> Delete
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="row mt-3">
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_info">
                            Showing {{ $serviceProviders->firstItem() }} to {{ $serviceProviders->lastItem() }} of {{ $serviceProviders->total() }} entries
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers float-end">
                            {{ $serviceProviders->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>