<div class="modal fade" id="serviceProviderModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceProviderModalTitle">Add New Service Provider</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="serviceProviderForm" method="POST">
                @csrf
                <div id="formMethod"></div> <!-- For PUT method when editing -->
                <input type="hidden" name="type" value="service_provider">
                
                <div class="modal-body">
                    <div id="formErrors" class="alert alert-danger d-none"></div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Provider Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" required 
                                       placeholder="Enter provider name" id="providerName">
                                <div class="invalid-feedback">Please provide a provider name.</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Vendor Code</label>
                                <input type="text" class="form-control" id="vendorCode" 
                                       placeholder="Auto-generated" readonly>
                                <small class="text-muted">This will be automatically generated</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Onboarding Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="onboarding_date" required 
                                       id="onboardingDate" value="{{ date('Y-m-d') }}">
                                <div class="invalid-feedback">Please select an onboarding date.</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Open Balance <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">KES</span>
                                    <input type="number" step="0.01" class="form-control" name="open_balance" 
                                           required placeholder="0.00" id="openBalance" value="0">
                                </div>
                                <div class="invalid-feedback">Please enter a valid balance.</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Balance Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="balance_type" required id="balanceType">
                                    <option value="credit">Credit</option>
                                    <option value="debit">Debit</option>
                                </select>
                                <div class="invalid-feedback">Please select a balance type.</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Contact Person</label>
                                <input type="text" class="form-control" name="contact_person" 
                                       placeholder="Enter contact person" id="contactPerson">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Email Address</label>
                                <input type="email" class="form-control" name="email" 
                                       placeholder="Enter email address" id="providerEmail">
                                <div class="invalid-feedback">Please enter a valid email address.</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Phone Number</label>
                                <input type="text" class="form-control" name="phone" 
                                       placeholder="Enter phone number" id="providerPhone">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Address</label>
                        <textarea class="form-control" name="address" rows="2" 
                                  placeholder="Enter address" id="providerAddress"></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Account Number</label>
                                <input type="text" class="form-control" name="account_number" 
                                       placeholder="Enter account number" id="accountNumber">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status" id="providerStatus">
                                    <option value="active" selected>Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Shipping Methods</label>
                        <div class="row">
                            @foreach(['air' => 'Air Freight', 'sea' => 'Sea Freight', 'land' => 'Land Transport', 'rail' => 'Rail'] as $value => $label)
                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="shipping_methods[]" 
                                           value="{{ $value }}" id="shipping{{ ucfirst($value) }}">
                                    <label class="form-check-label" for="shipping{{ ucfirst($value) }}">
                                        {{ $label }}
                                    </label>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea class="form-control" name="notes" rows="2" 
                                  placeholder="Additional notes" id="providerNotes"></textarea>
                    </div>
                    
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="is_default" 
                               id="is_default_provider" value="1">
                        <label class="form-check-label" for="is_default_provider">
                            Set as default service provider (Inhouse)
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitButton">
                        <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                        Save Service Provider
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>