@extends('layouts.clivax')

@section('title', 'Service Providers & Suppliers')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <h4 class="page-title">Service Providers & Suppliers Management</h4>
        </div>
    </div>
</div>

<!-- Type Toggle -->
<div class="row mb-3">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-center">
                    <div class="btn-group" role="group">
                        <input type="radio" class="btn-check" name="vendor-type" id="service-providers" autocomplete="off" checked>
                        <label class="btn btn-outline-primary" for="service-providers">
                            <i class="ri-truck-line me-1"></i> Service Providers
                        </label>

                        <input type="radio" class="btn-check" name="vendor-type" id="suppliers" autocomplete="off">
                        <label class="btn btn-outline-primary" for="suppliers">
                            <i class="ri-box-3-line me-1"></i> Suppliers
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Service Providers Section -->
<div class="vendor-section" id="service-providers-section">
    @include('vendor.service-providers.partials.providers-header')
    @include('vendor.service-providers.partials.providers-table')
</div>

<!-- Suppliers Section -->
<div class="vendor-section d-none" id="suppliers-section">
    @include('vendor.service-providers.partials.suppliers-header')
    @include('vendor.service-providers.partials.suppliers-table')
</div>

<!-- Modals -->
@include('vendor.service-providers.partials.modals.service-provider-modal')
@include('vendor.service-providers.partials.modals.supplier-modal')
@include('vendor.service-providers.partials.modals.route-modal')
@include('vendor.service-providers.partials.modals.payment-modal')

@endsection

@section('scripts')
<!-- Load utils first -->
<script src="{{ asset('js/suppliers/utils/helpers.js') }}"></script>

<!-- Load modules next -->
<script src="{{ asset('js/suppliers/modules/vendor-manager.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/modal-manager.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/search-manager.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/export-manager.js') }}"></script>

<!-- Load main app last -->
<script src="{{ asset('js/suppliers/suppliers.js') }}"></script>

<!-- Fallback inline script in case modules fail -->
<script>
// Simple fallback for toggle functionality
document.addEventListener('DOMContentLoaded', function() {
    // Basic toggle functionality
    const serviceProvidersRadio = document.getElementById('service-providers');
    const suppliersRadio = document.getElementById('suppliers');
    const serviceProvidersSection = document.getElementById('service-providers-section');
    const suppliersSection = document.getElementById('suppliers-section');

    if (serviceProvidersRadio && suppliersRadio) {
        serviceProvidersRadio.addEventListener('change', function() {
            if (this.checked) {
                serviceProvidersSection.classList.remove('d-none');
                suppliersSection.classList.add('d-none');
            }
        });

        suppliersRadio.addEventListener('change', function() {
            if (this.checked) {
                suppliersSection.classList.remove('d-none');
                serviceProvidersSection.classList.add('d-none');
            }
        });
    }

    // Basic search functionality
    document.querySelectorAll('.vendor-search').forEach(input => {
        input.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const table = e.target.closest('.card-body').querySelector('table');
            if (!table) return;
            
            const rows = table.querySelectorAll('tbody tr');
            
            rows.forEach(row => {
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            });
        });
    });

    console.log('Basic suppliers functionality loaded');
});
</script>
<script>
// Test if toggle is working
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded - testing toggle...');
    
    const serviceProvidersRadio = document.getElementById('service-providers');
    const suppliersRadio = document.getElementById('suppliers');
    
    if (serviceProvidersRadio && suppliersRadio) {
        console.log('Toggle radios found');
        
        serviceProvidersRadio.addEventListener('change', function() {
            console.log('Service Providers radio changed:', this.checked);
        });
        
        suppliersRadio.addEventListener('change', function() {
            console.log('Suppliers radio changed:', this.checked);
        });
    } else {
        console.log('Toggle radios NOT found');
    }
});
</script>
@endsection
