<div class="card mb-4 card-section">
    <div class="card-header">
        <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#pricingInfoCollapse" aria-expanded="false">
            <i class="ri-money-dollar-circle-line me-2"></i> 
            <span class="fw-semibold">Step 4: Service Provider & Pricing</span>
            <span class="badge bg-secondary ms-2" id="pricingStepStatus">4</span>
        </button>
    </div>
    <div class="collapse" id="pricingInfoCollapse" data-bs-parent="#shipmentForm">
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-md-6">
                    <label>Preferred Service Provider</label>
                    <select name="preferred_service_provider_id" id="preferred_service_provider_id" class="form-control" required>
                        <option value="">Select Service Provider</option>
                        @foreach($serviceProviders as $provider)
                            <option value="{{ $provider->id }}" 
                                data-base-url="{{ $provider->tracking_url_base ?? '#' }}"
                                {{ old('preferred_service_provider_id', $shipment->preferred_service_provider_id ?? '') == $provider->id ? 'selected' : '' }}>
                                {{ $provider->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="provider_tracking_link">Provider Tracking Link</label>
                    <input type="text" name="provider_tracking_link" id="provider_tracking_link" class="form-control" readonly>
                </div>
            </div>

            <!-- Pricing Breakdown -->
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="service_provider_charges">Service Provider Charges</label>
                    <div class="input-group">
                        <span class="input-group-text">$</span>
                        <input type="number" name="service_provider_charges" id="service_provider_charges" class="form-control" step="0.01" readonly>
                    </div>
                </div>
                
                <div class="col-md-4 mb-3">
                    <label for="my_price">My Price to Customer</label>
                    <div class="input-group">
                        <span class="input-group-text">$</span>
                        <input type="number" name="my_price" id="my_price" class="form-control" step="0.01" required>
                    </div>
                </div>
                
                <div class="col-md-4 mb-3">
                    <label>My Profit</label>
                    <div id="profitDisplay" class="profit-display">
                        $0.00
                    </div>
                </div>
            </div>

            <!-- Rate Information -->
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6 class="card-title">Applicable Rate</h6>
                            <div id="rateDisplay">
                                <p class="mb-0">Select route to see rate</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6 class="card-title">Currency</h6>
                            <div id="currencyDisplay">
                                <p class="mb-0">{{ $baseCurrency }} (default)</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6 class="card-title">Profit Margin</h6>
                            <div id="marginDisplay">
                                <p class="mb-0">0%</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-3">
                <button type="button" class="btn btn-success" onclick="validatePricingSection()">
                    <i class="ri-check-line"></i> Confirm Pricing
                </button>
            </div>
        </div>
    </div>
</div>