<div class="modal fade" id="manualRateModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Manual Rate Override</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="ri-alert-line"></i> Use this only if automatic rate calculation is not available
                </div>
                <div class="mb-3">
                    <label for="manual_service_provider_charges" class="form-label">Service Provider Charges</label>
                    <div class="input-group">
                        <span class="input-group-text">$</span>
                        <input type="number" class="form-control" id="manual_service_provider_charges" step="0.01" min="0">
                    </div>
                </div>
                <div class="mb-3">
                    <label for="manual_currency" class="form-label">Currency</label>
                    <select class="form-select" id="manual_currency">
                        @foreach($currencies as $currency)
                            <option value="{{ $currency->code }}" {{ $currency->code === $baseCurrency ? 'selected' : '' }}>
                                {{ $currency->code }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="mb-3">
                    <label for="manual_exchange_rate" class="form-label">Exchange Rate (to {{ $baseCurrency }})</label>
                    <input type="number" class="form-control" id="manual_exchange_rate" step="0.0001" min="0" value="1">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="applyManualRate()">Apply Manual Rate</button>
            </div>
        </div>
    </div>
</div>