@extends('layouts.clivax')

@section('title', 'Shipments')

@section('content')
<div class="card">
    <div class="card-body">
        <h4 class="header-title mb-3">Shipment List</h4>
<a href="{{ route('shipments.create') }}" class="btn btn-primary mb-3">+ New Shipment</a>
        <div class="table-responsive">
            <table class="table table-bordered align-middle table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Tracking</th>
                        <th>Customer</th>
                        <th>Mode</th>
                        <th>Category</th>
                        <th>Packages</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($shipments as $shipment)
                        <tr class="accordion-toggle cursor-pointer" data-bs-toggle="collapse" data-bs-target="#summary-{{ $shipment->id }}" aria-expanded="false">
                            <td><strong>{{ $shipment->main_tracking_no }}</strong></td>
                            <td>{{ $shipment->customer->name }}</td>
                            <td class="text-capitalize">{{ str_replace('_', ' ', $shipment->mode) }}</td>
                            <td>{{ $shipment->category->name ?? '—' }}</td>
                            <td>{{ $shipment->package_count }}</td>
                            <td>
                                <a href="{{ route('shipments.edit', $shipment->id) }}" class="btn btn-sm btn-primary">Edit</a>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="p-0">
                                <div id="summary-{{ $shipment->id }}" class="collapse bg-light">
                                    <div class="p-3">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h6 class="fw-bold">📦 Package Details</h6>
                                                <ul class="mb-3">
                                                    @foreach($shipment->packages as $pkg)
                                                        <li>
                                                            {{ $pkg->tracking_no }} — 
                                                            {{ $pkg->weight }} kg, 
                                                            {{ $pkg->length }}×{{ $pkg->width }}×{{ $pkg->height }} cm
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                            <div class="col-md-6">
                                                <h6 class="fw-bold">🛠 Services</h6>
                                                <ul class="mb-3">
                                                    @forelse($shipment->services as $svc)
                                                        <li>
                                                            {{ $svc->service->name }} — 
                                                            {{ number_format($svc->cost_amount, 2) }} {{ $svc->costCurrency->code ?? '' }}
                                                        </li>
                                                    @empty
                                                        <li>No additional services</li>
                                                    @endforelse
                                                </ul>
                                            </div>
                                        </div>
                                        <div>
                                            <a href="{{ asset('storage/labels/' . $shipment->packages->first()->label_filename) }}" target="_blank" class="btn btn-sm btn-secondary">
                                                📄 View Label
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted">No shipments found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
