@php
use App\Models\Currency;
$baseCurrency = Currency::base()->code;
$currencies = Currency::all();
@endphp

@props([
    'action' => route('shipments.store'),
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'serviceProviders' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
])

<div class="shipping-application">
    <!-- System Status Bar -->
    <div class="system-status-bar alert alert-info d-flex align-items-center mb-4">
        <i class="ri-information-line me-2"></i>
        <span id="systemStatus">Ready to create new shipment</span>
        <div class="ms-auto">
            <span class="badge bg-primary" id="formStepIndicator">Step 1 of 6</span>
        </div>
    </div>

    <form id="shipmentForm" method="POST" action="{{ $action }}" class="card p-4" enctype="multipart/form-data">
        @csrf
        @if($method !== 'POST')
            @method($method)
        @endif

        <!-- Hidden Fields -->
        <input type="hidden" name="base_currency" value="{{ $baseCurrency }}">
        <input type="hidden" name="original_currency" id="originalCurrency" value="{{ $baseCurrency }}">
        <input type="hidden" name="exchange_rate" id="exchangeRate" value="1">
        <input type="hidden" name="shipment_status" id="shipmentStatus" value="draft">
        <input type="hidden" name="otp_verification_code" id="otpVerificationCode">
        <input type="hidden" name="otp_verified" id="otpVerified" value="0">
        <input type="hidden" name="profit_amount" id="profitAmount" value="0">
        <input type="hidden" name="whatsapp_sent" id="whatsappSent" value="0">

        <!-- Step 1: Customer Information -->
        @include('shipments.partials.customer-info', [
            'customers' => $customers,
            'shipment' => $shipment,
            'countries' => $countries
        ])

        <!-- Step 2: Package Details -->
        @include('shipments.partials.package-details')

        <!-- Step 3: Route & Shipment Details -->
        @include('shipments.partials.route-details', [
            'countries' => $countries,
            'shipmentModes' => $shipmentModes,
            'cargoCategories' => $cargoCategories,
            'serviceProviders' => $serviceProviders,
            'shipment' => $shipment
        ])

        <!-- Step 4: Service Provider & Pricing -->
        @include('shipments.partials.pricing-details', [
            'serviceProviders' => $serviceProviders,
            'currencies' => $currencies,
            'baseCurrency' => $baseCurrency
        ])

        <!-- Step 5: Extra Services -->
        @include('shipments.partials.services', [
            'services' => $services,
            'currencies' => $currencies,
            'selectedServices' => $shipment->services ?? []
        ])

        <!-- Step 6: OTP Verification & Finalization -->
        @include('shipments.partials.verification-payment', [
            'baseCurrency' => $baseCurrency
        ])
    </form>

    <!-- Modals -->
    @include('shipments.partials.modals.customer-modal', ['countries' => $countries])
    @include('shipments.partials.modals.manual-rate-modal', ['currencies' => $currencies, 'baseCurrency' => $baseCurrency])
    @include('shipments.partials.modals.otp-modal')
    @include('shipments.partials.modals.waybill-modal')
</div>

@push('styles')
<style>
    .card-section { 
        margin-bottom: 1.5rem; 
        border: 1px solid #e9ecef; 
        border-radius: 0.5rem; 
        transition: all 0.3s ease;
    }
    .card-section .card-header { 
        background-color: #f8f9fa; 
        padding: 1rem 1.25rem; 
        border-bottom: 1px solid #e9ecef;
    }
    .card-section .card-header button { 
        font-weight: 600; 
        color: #495057;
        border: none;
        background: none;
        width: 100%;
        text-align: left;
    }
    .card-section .card-header button:hover {
        color: #0d6efd;
    }
    .required-field::after { 
        content: " *"; 
        color: #dc3545; 
    }
    .summary-section { 
        background-color: #f8f9fa; 
        padding: 1rem; 
        border-radius: 0.5rem; 
        border-left: 4px solid #0d6efd;
    }
    .payment-option { 
        flex: 1; 
        text-align: center; 
        padding: 1rem; 
        border: 2px solid #dee2e6; 
        border-radius: 0.5rem; 
        cursor: pointer; 
        transition: all 0.3s; 
    }
    .payment-option:hover, .payment-option.active { 
        background-color: #e7f1ff; 
        border-color: #0c63e4; 
        transform: translateY(-2px);
    }
    .profit-display { 
        background-color: #d4edda; 
        padding: 0.5rem; 
        border-radius: 0.25rem; 
        font-weight: bold; 
        border-left: 4px solid #28a745;
    }
    .service-provider-rate { 
        background-color: #fff3cd; 
        padding: 0.5rem; 
        border-radius: 0.25rem; 
        border-left: 4px solid #ffc107;
    }
    .otp-timer {
        font-family: 'Courier New', monospace;
        font-weight: bold;
        color: #dc3545;
    }
</style>
@endpush
@push('scripts')
<!-- Load modules in correct order -->
<script src="{{ asset('js/shipment/modules/utilities.js') }}"></script>
<script src="{{ asset('js/shipment/modules/step-manager.js') }}"></script>
<script src="{{ asset('js/shipment/modules/customer-manager.js') }}"></script>
<script src="{{ asset('js/shipment/modules/package-manager.js') }}"></script>
<script src="{{ asset('js/shipment/modules/route-manager.js') }}"></script>
<script src="{{ asset('js/shipment/modules/pricing-manager.js') }}"></script>
<script src="{{ asset('js/shipment/modules/services-manager.js') }}"></script>
<script src="{{ asset('js/shipment/modules/verification-manager.js') }}"></script>
<script src="{{ asset('js/shipment/modules/modal-manager.js') }}"></script>

<!-- Main shipment file -->
<script src="{{ asset('js/shipment/shipment.js') }}"></script>

<!-- Global functions with error handling -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Customer functions
    window.saveNewCustomer = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('customerManager')) {
            window.shipmentForm.getModule('customerManager').saveNewCustomer();
        } else {
            console.error('Customer manager not available');
            alert('Customer manager not available. Please refresh the page.');
        }
    }

    window.validateCustomerSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('customerManager')) {
            window.shipmentForm.getModule('customerManager').validateSection();
        } else {
            console.error('Customer manager not available');
        }
    }

    // Package functions
    window.validatePackagesSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('packageManager')) {
            window.shipmentForm.getModule('packageManager').validateSection();
        } else {
            console.error('Package manager not available');
        }
    }

    // Route functions
    window.validateRouteSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('routeManager')) {
            window.shipmentForm.getModule('routeManager').validateSection();
        } else {
            console.error('Route manager not available');
        }
    }

    // Pricing functions
    window.validatePricingSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('pricingManager')) {
            window.shipmentForm.getModule('pricingManager').validateSection();
        } else {
            console.error('Pricing manager not available');
        }
    }

    window.applyManualRate = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('pricingManager')) {
            window.shipmentForm.getModule('pricingManager').applyManualRate();
        } else {
            console.error('Pricing manager not available');
        }
    }

    // Services functions
window.validateServicesSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('servicesManager')) {
            window.shipmentForm.getModule('servicesManager').validateSection();
        } else {
            console.error('Services manager not available');
            // Fallback: move to next step
            const stepManager = window.shipmentForm.getModule('stepManager');
            if (stepManager) {
                stepManager.moveToStep(6);
            }
        }
    }
    
    // Verification functions
    window.validateVerificationSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            window.shipmentForm.getModule('verificationManager').validateSection();
        } else {
            console.error('Verification manager not available');
        }
    }

    // Additional verification functions
    window.verifyModalOTP = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            // Check if the method exists
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.verifyModalOTP) {
                verificationManager.verifyModalOTP();
            } else {
                alert('OTP verification not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.resendOTP = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.resendOTP) {
                verificationManager.resendOTP();
            } else {
                alert('OTP resend not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.sendWaybillWhatsApp = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.sendWaybillWhatsApp) {
                verificationManager.sendWaybillWhatsApp();
            } else {
                alert('WhatsApp sending not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.printWaybill = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.printWaybill) {
                verificationManager.printWaybill();
            } else {
                alert('Waybill printing not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.generateWaybillPreview = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.generateWaybillPreview) {
                verificationManager.generateWaybillPreview();
            } else {
                alert('Waybill preview not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.saveAsDraft = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.saveAsDraft) {
                verificationManager.saveAsDraft();
            } else {
                // Fallback: set status to draft and submit
                document.getElementById('shipmentStatus').value = 'draft';
                document.getElementById('shipmentForm').submit();
            }
        } else {
            // Fallback method
            document.getElementById('shipmentStatus').value = 'draft';
            document.getElementById('shipmentForm').submit();
        }
    }
});
</script>
@endpush