{{-- Shared form partial for create & edit --}}
@php $isEdit = isset($route); @endphp

<form action="{{ $isEdit ? route('shipment-routes.update', $route) : route('shipment-routes.store') }}" method="POST">
    @csrf
    @if($isEdit)
        @method('PUT')
    @endif

    <div class="row">
        <div class="col-md-6">
            <label>Origin Country</label>
            <select name="origin_country_id" class="form-control" required>
                <option value="">Select</option>
                @foreach($countries as $country)
                    <option value="{{ $country->id }}"
                        {{ old('origin_country_id', $route->origin_country_id ?? '') == $country->id ? 'selected' : '' }}>
                        {{ $country->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-6">
            <label>Destination Country</label>
            <select name="destination_country_id" class="form-control" required>
                <option value="">Select</option>
                @foreach($countries as $country)
                    <option value="{{ $country->id }}"
                        {{ old('destination_country_id', $route->destination_country_id ?? '') == $country->id ? 'selected' : '' }}>
                        {{ $country->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-6 mt-3">
            <label>Shipment Mode</label>
            <select name="shipment_mode_id" id="shipment_mode_select" class="form-control" required>
                <option value="">Select</option>
                @foreach($shipmentModes as $mode)
                    <option value="{{ $mode->id }}"
                        data-measure="{{ $mode->measure->code ?? '' }}"
                        {{ old('shipment_mode_id', $route->shipment_mode_id ?? '') == $mode->id ? 'selected' : '' }}>
                        {{ $mode->name }} ({{ $mode->measure->code ?? '?' }})
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-6 mt-3">
            <label>Cargo Category</label>
            <select name="cargo_category_id" class="form-control" required>
                <option value="">Select</option>
                @foreach($cargoCategories as $category)
                    <option value="{{ $category->id }}"
                        {{ old('cargo_category_id', $route->cargo_category_id ?? '') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-4 mt-3">
            <label>Currency</label>
            <select name="currency_id" class="form-control" required>
                <option value="">Select</option>
                @foreach($currencies as $currency)
                    <option value="{{ $currency->id }}"
                        {{ old('currency_id', $route->currency_id ?? '') == $currency->id ? 'selected' : '' }}>
                        {{ $currency->code }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="col-md-4 mt-3">
            <label>Rate Per Unit</label>
            <input type="number" name="rate_per_unit" class="form-control" step="0.01"
                value="{{ old('rate_per_unit', $route->rate_per_unit ?? '') }}">
        </div>

        <div class="col-md-4 mt-3">
            <label>Flat Rate</label>
            <input type="number" name="flat_rate" class="form-control" step="0.01"
                value="{{ old('flat_rate', $route->flat_rate ?? '') }}">
        </div>

        <div class="col-md-4 mt-3">
            <label>Minimum Weight (<span id="unit_label">{{ old('unit_type', $route->unit_type ?? 'unit') }}</span>)</label>
            <input type="number" name="minimum_weight" class="form-control" step="0.01"
                value="{{ old('minimum_weight', $route->minimum_weight ?? '') }}">
        </div>

        <div class="col-md-4 mt-3">
            <label>Unit Type</label>
            <input type="text" name="unit_type" id="unit_type_input" class="form-control"
                value="{{ old('unit_type', $route->unit_type ?? '') }}" readonly>
        </div>

        <div class="col-md-4 mt-3">
            <label>Weight Basis</label>
            <select name="weight_basis" class="form-control" required>
                <option value="">Select</option>
                @foreach(['gross', 'volumetric', 'higher'] as $basis)
                    <option value="{{ $basis }}"
                        {{ old('weight_basis', $route->weight_basis ?? '') == $basis ? 'selected' : '' }}>
                        {{ ucfirst($basis) }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>

    <div class="mt-4">
        <button class="btn btn-success" type="submit">
            {{ $isEdit ? 'Update' : 'Create' }} Route
        </button>
        <a href="{{ route('shipment-routes.index') }}" class="btn btn-secondary">Cancel</a>
    </div>
</form>

{{-- JS for Unit Type Auto Fill --}}
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const modeSelect = document.getElementById('shipment_mode_select');
        const unitInput = document.getElementById('unit_type_input');
        const unitLabel = document.getElementById('unit_label');

        const updateUnitType = () => {
            const selectedOption = modeSelect.options[modeSelect.selectedIndex];
            const measure = selectedOption.dataset.measure || '';
            unitInput.value = measure;
            unitLabel.textContent = measure || 'unit';
        };

        if (modeSelect && unitInput) {
            modeSelect.addEventListener('change', updateUnitType);
            updateUnitType(); // Run once on load
        }
    });
</script>
