@extends('layouts.clivax')

@section('content')
<div class="row">
  <div class="col-12">
    <h4>Services</h4>
    <a href="{{ route('services.create') }}" class="btn btn-primary mb-3">+ New Service</a>
    <table class="table table-bordered">
      <thead>
        <tr>
          <th>Name</th>
          <th>Cost Currency</th>
          <th>Charge Currency</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        @foreach($services as $s)
        <tr>
          <td>{{ $s->name }}</td>
          <td>{{ $s->costCurrency?->code ?? '-' }}</td>
          <td>{{ $s->chargeCurrency?->code ?? '-' }}</td>
          <td>
            <a href="{{ route('services.edit', $s) }}" class="btn btn-sm btn-warning">Edit</a>
            <form action="{{ route('services.destroy', $s) }}" method="POST" class="d-inline">
              @csrf
              @method('DELETE')
              <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
            </form>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
