@extends('layouts.clivax')

@section('content')
<div class="row">
  <div class="col-6">
    <h4>New Service</h4>
    <form action="{{ route('services.store') }}" method="POST">
      @csrf
      <div class="mb-3">
        <label>Name</label>
        <input name="name" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Cost Currency</label>
        <select name="cost_currency_id" class="form-control" required>
          @foreach($currencies as $c)
            <option value="{{ $c->id }}">{{ $c->code }}</option>
          @endforeach
        </select>
      </div>

      <div class="mb-3">
        <label>Charge Currency</label>
        <select name="charge_currency_id" class="form-control" required>
          @foreach($currencies as $c)
            <option value="{{ $c->id }}">{{ $c->code }}</option>
          @endforeach
        </select>
      </div>

      <div class="mb-3">
        <label>Cost Amount</label>
        <input type="number" name="cost_amount" class="form-control" step="0.01" required>
      </div>

      <div class="mb-3">
        <label>Selling Price</label>
        <input type="number" name="selling_price" class="form-control" step="0.01" required>
      </div>

      <div class="mb-3">
        <label>Profit Margin</label>
        <input type="number" name="profit_margin" class="form-control" step="0.01" required>
      </div>

      <button class="btn btn-success">Create</button>
      <a href="{{ route('services.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
  </div>
</div>
@endsection
