<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    {{-- CSS should be loaded here --}}
    @include('partials.head-css')

    <title>{{ $title ?? 'Smart Shipping System' }}</title>
</head>
<body>
    @include('partials.topbar')

    <div id="layout-wrapper">
        @include('partials.sidebar')

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    @yield('content')
                </div>
            </div>

            @include('partials.footer')
        </div>
    </div>

    {{-- Scripts should be loaded AFTER DOM --}}
    @include('partials.vendor-scripts')
    
    @stack('scripts')
</body>
</html>
