@extends('layouts.clivax')

@section('content')
<div class="row">
  <div class="col-12">
    <h4>Customers</h4>
    <a href="{{ route('customers.create') }}" class="btn btn-primary mb-3">+ New Customer</a>
    <table class="table table-bordered">
      <thead><tr><th>Name</th><th>Phone</th><th>Email</th><th>Actions</th></tr></thead>
      <tbody>
        @foreach($customers as $c)
        <tr>
          <td>{{ $c->name }}</td>
          <td>{{ $c->phone }}</td>
          <td>{{ $c->email }}</td>
          <td>
            <a href="{{ route('customers.edit',$c) }}" class="btn btn-sm btn-warning">Edit</a>
            <form action="{{ route('customers.destroy',$c) }}" method="POST" class="d-inline">
              @csrf @method('DELETE')
              <button class="btn btn-sm btn-danger">Delete</button>
            </form>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
