@extends('layouts.clivax')

@section('title', 'Currency Exchange Rates')

@section('content')
<div class="container-fluid">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center py-3">
            <h5 class="mb-0">
                <i class="ri-exchange-dollar-line me-2"></i>Currency Exchange Rates
            </h5>
            <a href="{{ route('currencies.create') }}" class="btn btn-light">
                <i class="ri-add-line me-1"></i> Add Currency
            </a>
        </div>
        
        <div class="card-body p-0">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show m-3" role="alert">
                    <i class="ri-check-line me-2"></i>{{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            
            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show m-3" role="alert">
                    <i class="ri-error-warning-line me-2"></i>{{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th class="ps-4">Code</th>
                            <th>Name</th>
                            <th>Symbol</th>
                            <th class="text-end pe-4">Buying Rate</th>
                            <th class="text-end pe-4">Selling Rate</th>
                            <th class="text-end pe-4">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($currencies as $currency)
                        <tr class="{{ $currency->code === 'KES' ? 'table-active' : '' }}">
                            <td class="ps-4 fw-bold">{{ $currency->code }}</td>
                            <td>{{ $currency->name }}</td>
                            <td>
                                @if($currency->symbol)
                                    <span class="badge bg-light text-dark border">{{ $currency->symbol }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td class="text-end pe-4">{{ number_format($currency->buying_exchange_rate, 4) }} KES</td>
                            <td class="text-end pe-4">{{ number_format($currency->selling_exchange_rate, 4) }} KES</td>
                            <td class="text-end pe-4">
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('currencies.edit', $currency->id) }}" 
                                       class="btn btn-sm btn-outline-primary rounded-circle"
                                       title="Edit"
                                       data-bs-toggle="tooltip">
                                        <i class="ri-edit-line"></i>
                                    </a>
                                    
                                    @if($currency->code !== 'KES')
                                        <form action="{{ route('currencies.destroy', $currency->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="btn btn-sm btn-outline-danger rounded-circle"
                                                    onclick="return confirm('Are you sure you want to delete this currency?')"
                                                    title="{{ $currency->services()->exists() ? 'Currency is in use' : 'Delete' }}"
                                                    @if($currency->services()->exists()) disabled @endif
                                                    data-bs-toggle="tooltip">
                                                <i class=" far fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <i class="ri-exchange-funds-line display-5"></i>
                                <p class="mt-2">No currencies found</p>
                                <a href="{{ route('currencies.create') }}" class="btn btn-primary mt-2">
                                    <i class="ri-add-line me-1"></i> Add First Currency
                                </a>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if($currencies->hasPages())
            <div class="card-footer bg-transparent">
                <div class="d-flex justify-content-center">
                    {{ $currencies->links('vendor.pagination.bootstrap-5') }}
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Initialize tooltips
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>
@endpush
