<?php include 'partials/session.php'; ?>
<?php include 'partials/main.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <?php includeFileWithVariables('partials/title-meta.php', ['title' => 'Shipment Entry']); ?>
  <?php include 'partials/head-css.php'; ?>
  <style>
    .card-section {
      margin-bottom: 1.5rem;
      border: 1px solid #e9ecef;
      border-radius: 0.5rem;
    }
    .card-section .card-body {
      padding: 1.5rem;
    }
    .section-title {
      border-bottom: 1px solid #dee2e6;
      padding-bottom: 0.5rem;
      margin-bottom: 1.5rem;
      font-weight: 600;
      color: #495057;
    }
    .readonly-field {
      background-color: #f8f9fa;
    }
    .currency-selector {
      min-width: 100px;
    }
    .badge-rate-source {
      font-size: 0.75rem;
    }
    .box-entry {
      background-color: #f8f9fa;
      padding: 1rem;
      margin-bottom: 1rem;
      border-radius: 0.25rem;
      border: 1px solid #dee2e6;
    }
    .image-preview-container {
      display: flex;
      flex-wrap: wrap;
      gap: 0.5rem;
      margin-top: 0.5rem;
    }
    .image-preview {
      width: 80px;
      height: 80px;
      object-fit: cover;
      border: 1px solid #dee2e6;
      border-radius: 0.25rem;
    }
    .accordion-button:not(.collapsed) {
      background-color: #e7f1ff;
      color: #0c63e4;
    }
    .package-details-section {
      display: none;
    }
    .summary-section {
      background-color: #f8f9fa;
      padding: 1rem;
      border-radius: 0.5rem;
      margin-top: 1rem;
    }
    .payment-options {
      display: flex;
      gap: 1rem;
      margin-top: 1rem;
    }
    .payment-option {
      flex: 1;
      text-align: center;
      padding: 1rem;
      border: 1px solid #dee2e6;
      border-radius: 0.5rem;
      cursor: pointer;
      transition: all 0.3s;
    }
    .payment-option:hover, .payment-option.active {
      background-color: #e7f1ff;
      border-color: #0c63e4;
    }
    .form-section {
      margin-bottom: 2rem;
    }
    .required-field::after {
      content: " *";
      color: #dc3545;
    }
    .accordion-item {
      margin-bottom: 1rem;
      border: 1px solid rgba(0,0,0,.125);
      border-radius: 0.5rem;
    }
    .accordion-button {
      font-weight: 600;
    }
    .rate-info {
      background-color: #f8f9fa;
      padding: 0.75rem;
      border-radius: 0.25rem;
      margin-top: 1rem;
    }
    .package-accordion {
      margin-bottom: 1rem;
    }
  </style>
</head>

<body>
  <?php include 'partials/body.php'; ?>
  <div id="layout-wrapper">
    <?php include 'partials/menu.php'; ?>

    <div class="main-content">
      <div class="page-content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0">Shipment Entry</h4>
                <div class="page-title-right">
                  <button class="btn btn-outline-secondary btn-sm" onclick="location.reload()">
                    <i class="ri-refresh-line align-middle"></i> Reset Form
                  </button>
                </div>
              </div>
            </div>
          </div>

          <form id="shipmentForm" class="needs-validation" novalidate>
            <!-- Customer Information Accordion -->
            <div class="card card-section">
              <div class="card-body">
                <div class="accordion" id="customerAccordion">
                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#customerInfo" aria-expanded="true" aria-controls="customerInfo">
                        <i class="ri-user-line me-2"></i> Customer Information
                      </button>
                    </h2>
                    <div id="customerInfo" class="accordion-collapse collapse show" data-bs-parent="#customerAccordion">
                      <div class="accordion-body">
                        <div class="row">
                          <div class="col-md-6 mb-3">
                            <label for="customerName" class="form-label required-field">Customer Name</label>
                            <input type="text" class="form-control" id="customerName" placeholder="Enter customer name" required>
                          </div>
                          <div class="col-md-6 mb-3">
                            <label for="customerPhone" class="form-label required-field">Telephone</label>
                            <input type="text" class="form-control" id="customerPhone" placeholder="Enter phone number" required>
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-6 mb-3">
                            <label for="customerId" class="form-label">ID Number</label>
                            <input type="text" class="form-control" id="customerId" placeholder="Enter ID number">
                          </div>
                          <div class="col-md-6 mb-3">
                            <label for="customerOtp" class="form-label">OTP</label>
                            <input type="text" class="form-control" id="customerOtp" placeholder="Enter OTP">
                          </div>
                        </div>
                        
                        <div class="form-check mb-3">
                          <input class="form-check-input" type="checkbox" value="" id="sendingOnBehalf">
                          <label class="form-check-label" for="sendingOnBehalf">
                            Sending on behalf of someone else
                          </label>
                        </div>
                        
                        <div id="senderInfo" class="d-none">
                          <h6 class="mt-3 mb-3">Sender Information</h6>
                          <div class="row">
                            <div class="col-md-6 mb-3">
                              <label for="senderName" class="form-label">Sender Name</label>
                              <input type="text" class="form-control" id="senderName" placeholder="Enter sender name">
                            </div>
                            <div class="col-md-6 mb-3">
                              <label for="senderPhone" class="form-label">Sender Telephone</label>
                              <input type="text" class="form-control" id="senderPhone" placeholder="Enter sender phone">
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-md-6 mb-3">
                              <label for="senderOtp" class="form-label">Sender OTP</label>
                              <input type="text" class="form-control" id="senderOtp" placeholder="Enter sender OTP">
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Package Details Accordion -->
            <div class="card card-section">
              <div class="card-body">
                <div class="accordion" id="packageAccordion">
                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#packageInfo" aria-expanded="false" aria-controls="packageInfo">
                        <i class="ri-package-line me-2"></i> Package Details
                      </button>
                    </h2>
                    <div id="packageInfo" class="accordion-collapse collapse" data-bs-parent="#packageAccordion">
                      <div class="accordion-body">
                        <div class="row">
                          <div class="col-md-4 mb-3">
                            <label for="numPieces" class="form-label required-field">Number of Pieces</label>
                            <input type="number" id="numPieces" class="form-control" min="1" placeholder="e.g. 3" required>
                          </div>
                        </div>
                        
                        <div id="packageDetails" class="package-details-section">
                          <!-- Package details will be generated here -->
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Shipment Details Accordion -->
            <div class="card card-section">
              <div class="card-body">
                <div class="accordion" id="shipmentAccordion">
                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#shipmentInfo" aria-expanded="false" aria-controls="shipmentInfo">
                        <i class="ri-ship-line me-2"></i> Shipment Details
                      </button>
                    </h2>
                    <div id="shipmentInfo" class="accordion-collapse collapse" data-bs-parent="#shipmentAccordion">
                      <div class="accordion-body">
                        <div id="shipmentSummary" class="summary-section mb-4">
                          <p><strong>Package Summary:</strong> <span id="totalPackages">0</span> packages, Total Weight: <span id="totalWeight">0</span> kgs</p>
                        </div>
                        
                        <div class="row">
                          <div class="col-md-4 mb-3">
                            <label for="shipmentType" class="form-label required-field">Shipment Type</label>
                            <select id="shipmentType" class="form-select" required>
                              <option value="">-- Select Type --</option>
                              <option value="air_standard">Standard Air</option>
                              <option value="air_consolidated">Consolidated Air</option>
                              <option value="sea_standard">Standard Sea</option>
                              <option value="sea_consolidated">Consolidated Sea</option>
                              <option value="courier">Courier</option>
                            </select>
                          </div>

                          <div class="col-md-4 mb-3">
                            <label for="tracking" class="form-label">Tracking Number</label>
                            <div class="input-group">
                              <input type="text" id="tracking" class="form-control readonly-field" readonly>
                              <button class="btn btn-outline-secondary" type="button" id="validateTrackingBtn">
                                <i class="ri-check-line"></i> Validate
                              </button>
                            </div>
                          </div>
                        </div>

                        <div class="row">
                          <div class="col-md-4 mb-3">
                            <label for="originCountry" class="form-label required-field">Origin Country</label>
                            <select id="originCountry" class="form-select" required>
                              <option value="">-- Select Country --</option>
                              <!-- Countries will be populated via JavaScript -->
                            </select>
                          </div>

                          <div class="col-md-4 mb-3">
                            <label for="destCountry" class="form-label required-field">Destination Country</label>
                            <select id="destCountry" class="form-select" required>
                              <option value="">-- Select Country --</option>
                              <!-- Countries will be populated via JavaScript -->
                            </select>
                          </div>
                        </div>
                        
                        <div class="row">
                          <div class="col-md-6 mb-3">
                            <label for="departDate" class="form-label required-field">Departure Date</label>
                            <input type="date" id="departDate" class="form-control" required>
                          </div>

                          <div class="col-md-6 mb-3">
                            <label for="etaDate" class="form-label required-field">ETA Date</label>
                            <input type="date" id="etaDate" class="form-control" required>
                          </div>
                        </div>

                        <div class="row">
                          <div class="col-md-6 mb-3">
                            <label for="goodsCategory" class="form-label required-field">Goods Category</label>
                            <select id="goodsCategory" class="form-select" required>
                              <option value="">-- Select Category --</option>
                              <!-- Categories will be populated via JavaScript -->
                            </select>
                          </div>
                        </div>
                        
                        <!-- Shipping Rates Accordion -->
                        <div class="accordion mt-4" id="ratesAccordion">
                          <div class="accordion-item">
                            <h2 class="accordion-header">
                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#ratesInfo" aria-expanded="false" aria-controls="ratesInfo">
                                <i class="ri-money-dollar-circle-line me-2"></i> Shipping Rates & Billing
                              </button>
                            </h2>
                            <div id="ratesInfo" class="accordion-collapse collapse" data-bs-parent="#ratesAccordion">
                              <div class="accordion-body">
                                <div class="rate-info">
                                  <p><strong>Available Rates:</strong> Based on your selected route, category, and shipping mode</p>
                                  <div id="availableRates">
                                    <!-- Rates will be populated here -->
                                  </div>
                                </div>
                                
                                <div class="row mt-3">
                                  <div class="col-md-6 mb-3">
                                    <label for="billingCurrency" class="form-label required-field">Billing Currency</label>
                                    <select id="billingCurrency" class="form-select" required>
                                      <option value="">-- Select Currency --</option>
                                      <!-- Currencies will be populated via JavaScript -->
                                    </select>
                                  </div>
                                </div>

                                <div id="stdRateWrap" class="row">
                                  <div class="col-md-6 mb-3">
                                    <label>Freight Rate</label>
                                    <div class="input-group">
                                      <input type="number" id="stdRateInput" class="form-control" placeholder="Rate" step="0.01">
                                      <select id="stdCurrencyInput" class="form-select currency-selector">
                                        <!-- Currencies will be populated via JavaScript -->
                                      </select>
                                      <button type="button" id="editRateBtn" class="btn btn-outline-primary">
                                        <i class="ri-edit-line"></i> Edit
                                      </button>
                                    </div>
                                  </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-4 mb-3">
                                    <label for="billingRate" class="form-label">Billing Rate</label>
                                    <input type="text" id="billingRate" class="form-control readonly-field" readonly>
                                  </div>

                                  <div class="col-md-4 mb-3">
                                    <label for="billingAmount" class="form-label">Billing Amount</label>
                                    <input type="text" id="billingAmount" class="form-control readonly-field" readonly>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Extra Services Accordion -->
            <div class="card card-section">
              <div class="card-body">
                <div class="accordion" id="servicesAccordion">
                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#servicesInfo" aria-expanded="false" aria-controls="servicesInfo">
                        <i class="ri-service-line me-2"></i> Extra Services
                      </button>
                    </h2>
                    <div id="servicesInfo" class="accordion-collapse collapse" data-bs-parent="#servicesAccordion">
                      <div class="accordion-body">
                        <div class="row g-2 mb-3">
                          <div class="col-md-3">
                            <select id="serviceSelect" class="form-select">
                              <option value="">Loading services...</option>
                            </select>
                          </div>
                          <div class="col-md-2">
                            <input type="number" step="0.01" id="serviceCost" class="form-control" placeholder="Cost">
                          </div>
                          <div class="col-md-2">
                            <input type="number" step="0.01" id="serviceCharge" class="form-control" placeholder="Charge">
                          </div>
                          <div class="col-md-2">
                            <select id="serviceCurrency" class="form-select currency-selector">
                              <option value="">Loading currencies...</option>
                            </select>
                          </div>
                          <div class="col-md-1">
                            <input type="number" step="0.01" id="buyRate" class="form-control" placeholder="Buy">
                          </div>
                          <div class="col-md-1">
                            <input type="number" step="0.01" id="sellRate" class="form-control" placeholder="Sell">
                          </div>
                          <div class="col-md-1">
                            <button type="button" id="addServiceBtn" class="btn btn-primary btn-sm">
                              <i class="ri-add-line"></i> Add
                            </button>
                          </div>
                        </div>

                        <div class="table-responsive">
                          <table class="table table-bordered table-sm">
                            <thead class="table-light">
                              <tr>
                                <th>Service</th>
                                <th>Currency</th>
                                <th>Cost</th>
                                <th>Charge</th>
                                <th>Buy</th>
                                <th>Sell</th>
                                <th>Cost KES</th>
                                <th>Charge KES</th>
                                <th>Profit</th>
                                <th>Action</th>
                              </tr>
                            </thead>
                            <tbody id="servicesTable"></tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Payment & Finalization Accordion -->
            <div class="card card-section">
              <div class="card-body">
                <div class="accordion" id="paymentAccordion">
                  <div class="accordion-item">
                    <h2 class="accordion-header">
                      <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#paymentInfo" aria-expanded="false" aria-controls="paymentInfo">
                        <i class="ri-bank-card-line me-2"></i> Payment & Finalization
                      </button>
                    </h2>
                    <div id="paymentInfo" class="accordion-collapse collapse" data-bs-parent="#paymentAccordion">
                      <div class="accordion-body">
                        <div class="row">
                          <div class="col-md-6">
                            <h6>Payment Method</h6>
                            <div class="payment-options">
                              <div class="payment-option" data-payment="now">
                                <i class="ri-money-dollar-circle-line" style="font-size: 2rem;"></i>
                                <p>Pay Now</p>
                              </div>
                              <div class="payment-option" data-payment="delivery">
                                <i class="ri-truck-line" style="font-size: 2rem;"></i>
                                <p>Pay on Delivery</p>
                              </div>
                            </div>
                            
                            <div id="paymentDetails" class="mt-3 d-none">
                              <div class="row">
                                <div class="col-md-6 mb-3">
                                  <label for="paymentMethod" class="form-label">Payment Method</label>
                                  <select id="paymentMethod" class="form-select">
                                    <option value="mpesa">M-Pesa</option>
                                    <option value="cash">Cash</option>
                                    <option value="card">Credit/Debit Card</option>
                                  </select>
                                </div>
                              </div>
                            </div>
                          </div>
                          
                          <div class="col-md-6">
                            <div class="summary-section">
                              <h6>Shipment Summary</h6>
                              <p><strong>Total Amount:</strong> <span id="finalAmount">0.00</span> KES</p>
                              <p><strong>Tracking Number:</strong> <span id="finalTracking">Not generated</span></p>
                              <p><strong>Estimated Delivery:</strong> <span id="finalEta">-</span></p>
                            </div>
                          </div>
                        </div>
                        
                        <div class="mt-4">
                          <button type="submit" class="btn btn-success me-2">
                            <i class="ri-check-line"></i> Submit Shipment
                          </button>
                          <button type="button" class="btn btn-outline-secondary" onclick="generateWaybill()">
                            <i class="ri-barcode-line"></i> Generate Waybill
                          </button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <?php include 'partials/vendor-scripts.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
  
  <script>
    // Sample data for dropdowns (in a real app, this would come from an API)
    const countries = ['Kenya', 'United States', 'United Kingdom', 'China', 'Germany', 'France', 'Japan'];
    const currencies = ['KES', 'USD', 'EUR', 'GBP', 'CNY'];
    const goodsCategories = ['Electronics', 'Clothing', 'Documents', 'Food Items', 'Machinery', 'Personal Effects'];
    const services = ['Insurance', 'Packing', 'Storage', 'Customs Clearance', 'Door-to-Door Delivery'];
    
    // Shipping rates data (simulated)
    const shippingRates = {
      'us_kenya_air_standard': { rate: 15.50, currency: 'USD' },
      'us_kenya_sea_standard': { rate: 8.75, currency: 'USD' },
      'uk_kenya_air_standard': { rate: 12.25, currency: 'USD' },
      'china_kenya_air_standard': { rate: 10.50, currency: 'USD' }
    };
    
    // Initialize form elements
    document.addEventListener('DOMContentLoaded', function() {
      // Populate countries
      const originCountry = document.getElementById('originCountry');
      const destCountry = document.getElementById('destCountry');
      
      countries.forEach(country => {
        const option1 = document.createElement('option');
        option1.value = country.toLowerCase().replace(' ', '_');
        option1.textContent = country;
        originCountry.appendChild(option1);
        
        const option2 = document.createElement('option');
        option2.value = country.toLowerCase().replace(' ', '_');
        option2.textContent = country;
        destCountry.appendChild(option2);
      });
      
      // Populate goods categories
      const goodsCategory = document.getElementById('goodsCategory');
      goodsCategories.forEach(category => {
        const option = document.createElement('option');
        option.value = category.toLowerCase().replace(' ', '_');
        option.textContent = category;
        goodsCategory.appendChild(option);
      });
      
      // Populate currencies
      const stdCurrencyInput = document.getElementById('stdCurrencyInput');
      const serviceCurrency = document.getElementById('serviceCurrency');
      const billingCurrency = document.getElementById('billingCurrency');
      
      currencies.forEach(currency => {
        const option1 = document.createElement('option');
        option1.value = currency;
        option1.textContent = currency;
        stdCurrencyInput.appendChild(option1);
        
        const option2 = document.createElement('option');
        option2.value = currency;
        option2.textContent = currency;
        serviceCurrency.appendChild(option2);
        
        const option3 = document.createElement('option');
        option3.value = currency;
        option3.textContent = currency;
        billingCurrency.appendChild(option3);
      });
      
      // Populate services
      const serviceSelect = document.getElementById('serviceSelect');
      services.forEach(service => {
        const option = document.createElement('option');
        option.value = service.toLowerCase().replace(' ', '_');
        option.textContent = service;
        serviceSelect.appendChild(option);
      });
      
      // Generate tracking number
      generateTrackingNumber();
      
      // Event listeners
      document.getElementById('numPieces').addEventListener('change', generatePackageFields);
      document.getElementById('sendingOnBehalf').addEventListener('change', toggleSenderInfo);
      document.querySelectorAll('.payment-option').forEach(option => {
        option.addEventListener('click', selectPaymentOption);
      });
      document.getElementById('validateTrackingBtn').addEventListener('click', validateTracking);
      document.getElementById('addServiceBtn').addEventListener('click', addService);
      document.getElementById('shipmentType').addEventListener('change', updateShippingRates);
      document.getElementById('originCountry').addEventListener('change', updateShippingRates);
      document.getElementById('destCountry').addEventListener('change', updateShippingRates);
      document.getElementById('goodsCategory').addEventListener('change', updateShippingRates);
    });
    
    function generateTrackingNumber() {
      const prefix = 'TRK';
      const randomNum = Math.floor(100000 + Math.random() * 900000);
      document.getElementById('tracking').value = `${prefix}${randomNum}`;
      document.getElementById('finalTracking').textContent = `${prefix}${randomNum}`;
    }
    
    function validateTracking() {
      const tracking = document.getElementById('tracking').value;
      if (tracking) {
        alert(`Tracking number ${tracking} is valid.`);
      } else {
        alert('Please generate a tracking number first.');
      }
    }
    
    function toggleSenderInfo() {
      const senderInfo = document.getElementById('senderInfo');
      if (document.getElementById('sendingOnBehalf').checked) {
        senderInfo.classList.remove('d-none');
      } else {
        senderInfo.classList.add('d-none');
      }
    }
    
    function generatePackageFields() {
      const numPieces = parseInt(document.getElementById('numPieces').value);
      const packageDetails = document.getElementById('packageDetails');
      
      if (numPieces > 0) {
        packageDetails.innerHTML = '';
        packageDetails.classList.remove('d-none');
        
        for (let i = 1; i <= numPieces; i++) {
          const packageHtml = `
            <div class="accordion package-accordion" id="packageAccordion${i}">
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#packageCollapse${i}" aria-expanded="false" aria-controls="packageCollapse${i}">
                    Package ${i}
                  </button>
                </h2>
                <div id="packageCollapse${i}" class="accordion-collapse collapse" data-bs-parent="#packageAccordion${i}">
                  <div class="accordion-body">
                    <div class="row">
                      <div class="col-md-3 mb-3">
                        <label for="packageLength${i}" class="form-label">Length (cm)</label>
                        <input type="number" class="form-control" id="packageLength${i}" placeholder="Length">
                      </div>
                      <div class="col-md-3 mb-3">
                        <label for="packageWidth${i}" class="form-label">Width (cm)</label>
                        <input type="number" class="form-control" id="packageWidth${i}" placeholder="Width">
                      </div>
                      <div class="col-md-3 mb-3">
                        <label for="packageHeight${i}" class="form-label">Height (cm)</label>
                        <input type="number" class="form-control" id="packageHeight${i}" placeholder="Height">
                      </div>
                      <div class="col-md-3 mb-3">
                        <label for="packageWeight${i}" class="form-label">Weight (kg)</label>
                        <input type="number" class="form-control" id="packageWeight${i}" placeholder="Weight" step="0.1">
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-12 mb-3">
                        <label for="packageContents${i}" class="form-label">Contents</label>
                        <textarea class="form-control" id="packageContents${i}" rows="2" placeholder="List items in this package"></textarea>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-md-12 mb-3">
                        <label for="packageImages${i}" class="form-label">Upload Images (Max 3)</label>
                        <input type="file" class="form-control" id="packageImages${i}" multiple accept="image/*">
                        <div class="image-preview-container" id="imagePreview${i}"></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          `;
          packageDetails.innerHTML += packageHtml;
          
          // Add event listener for image preview
          document.getElementById(`packageImages${i}`).addEventListener('change', function(e) {
            previewImages(e.target, `imagePreview${i}`);
          });
          
          // Add event listener for weight update
          document.getElementById(`packageWeight${i}`).addEventListener('change', updateTotalWeight);
        }
        
        // Update summary
        document.getElementById('totalPackages').textContent = numPieces;
        updateTotalWeight();
      } else {
        packageDetails.classList.add('d-none');
        document.getElementById('totalPackages').textContent = '0';
        document.getElementById('totalWeight').textContent = '0';
      }
    }
    
    function updateTotalWeight() {
      const numPieces = parseInt(document.getElementById('numPieces').value);
      let totalWeight = 0;
      
      for (let i = 1; i <= numPieces; i++) {
        const weightInput = document.getElementById(`packageWeight${i}`);
        if (weightInput && weightInput.value) {
          totalWeight += parseFloat(weightInput.value);
        }
      }
      
      document.getElementById('totalWeight').textContent = totalWeight.toFixed(2);
    }
    
    function previewImages(input, previewId) {
      const previewContainer = document.getElementById(previewId);
      previewContainer.innerHTML = '';
      
      if (input.files) {
        const files = Array.from(input.files).slice(0, 3); // Limit to 3 images
        
        files.forEach(file => {
          const reader = new FileReader();
          
          reader.onload = function(e) {
            const img = document.createElement('img');
            img.src = e.target.result;
            img.classList.add('image-preview');
            previewContainer.appendChild(img);
          }
          
          reader.readAsDataURL(file);
        });
      }
    }
    
    function selectPaymentOption(e) {
      const options = document.querySelectorAll('.payment-option');
      options.forEach(option => option.classList.remove('active'));
      
      const selectedOption = e.currentTarget;
      selectedOption.classList.add('active');
      
      const paymentDetails = document.getElementById('paymentDetails');
      if (selectedOption.dataset.payment === 'now') {
        paymentDetails.classList.remove('d-none');
      } else {
        paymentDetails.classList.add('d-none');
      }
    }
    
    function updateShippingRates() {
      const origin = document.getElementById('originCountry').value;
      const destination = document.getElementById('destCountry').value;
      const shipmentType = document.getElementById('shipmentType').value;
      const category = document.getElementById('goodsCategory').value;
      
      if (origin && destination && shipmentType) {
        const rateKey = `${origin}_${destination}_${shipmentType}`;
        const rateInfo = shippingRates[rateKey];
        
        const availableRates = document.getElementById('availableRates');
        
        if (rateInfo) {
          availableRates.innerHTML = `
            <p><strong>Rate:</strong> ${rateInfo.rate} ${rateInfo.currency}/kg</p>
            <p><em>Based on ${origin.replace('_', ' ')} to ${destination.replace('_', ' ')} via ${shipmentType.replace('_', ' ')}</em></p>
          `;
          
          // Auto-fill the rate input
          document.getElementById('stdRateInput').value = rateInfo.rate;
          document.getElementById('stdCurrencyInput').value = rateInfo.currency;
        } else {
          availableRates.innerHTML = '<p>No specific rates available for this route. Please enter manually.</p>';
        }
      }
    }
    
    function addService() {
      const serviceSelect = document.getElementById('serviceSelect');
      const serviceCost = document.getElementById('serviceCost');
      const serviceCharge = document.getElementById('serviceCharge');
      const serviceCurrency = document.getElementById('serviceCurrency');
      const buyRate = document.getElementById('buyRate');
      const sellRate = document.getElementById('sellRate');
      
      if (!serviceSelect.value) {
        alert('Please select a service');
        return;
      }
      
      const serviceName = serviceSelect.options[serviceSelect.selectedIndex].text;
      const currency = serviceCurrency.value;
      
      // Calculate conversions (simplified)
      const costKES = parseFloat(serviceCost.value) * (currency === 'KES' ? 1 : 0.009); // Simplified conversion
      const chargeKES = parseFloat(serviceCharge.value) * (currency === 'KES' ? 1 : 0.009); // Simplified conversion
      const profit = chargeKES - costKES;
      
      const servicesTable = document.getElementById('servicesTable');
      const newRow = servicesTable.insertRow();
      
      newRow.innerHTML = `
        <td>${serviceName}</td>
        <td>${currency}</td>
        <td>${serviceCost.value}</td>
        <td>${serviceCharge.value}</td>
        <td>${buyRate.value}</td>
        <td>${sellRate.value}</td>
        <td>${costKES.toFixed(2)}</td>
        <td>${chargeKES.toFixed(2)}</td>
        <td>${profit.toFixed(2)}</td>
        <td>
          <button type="button" class="btn btn-sm btn-outline-danger" onclick="this.parentNode.parentNode.remove()">
            <i class="ri-delete-bin-line"></i>
          </button>
        </td>
      `;
      
      // Clear form
      serviceCost.value = '';
      serviceCharge.value = '';
      buyRate.value = '';
      sellRate.value = '';
    }
    
    function generateWaybill() {
      // In a real application, this would generate a PDF or display a waybill
      alert('Waybill generation functionality would be implemented here.');
    }
  </script>
</body>
</html>