// Search Management Module
class SearchManager {
    constructor(suppliersApp) {
        this.suppliersApp = suppliersApp;
    }

    init() {
        this.setupSearchListeners();
    }

    setupSearchListeners() {
        // Search functionality
        document.querySelectorAll('.vendor-search').forEach(input => {
            input.addEventListener('input', (e) => this.handleSearch(e));
        });

        // Filter functionality
        document.querySelectorAll('.dropdown-item[data-filter]').forEach(item => {
            item.addEventListener('click', (e) => this.handleFilter(e));
        });
    }

    handleSearch(event) {
        const searchTerm = event.target.value.toLowerCase();
        const table = event.target.closest('.card-body')?.querySelector('table');
        if (!table) return;
        
        const rows = table.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(searchTerm) ? '' : 'none';
        });
    }

    handleFilter(event) {
        event.preventDefault();
        const filter = event.target.getAttribute('data-filter');
        const table = event.target.closest('.card-body')?.querySelector('table');
        if (!table) return;
        
        const rows = table.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            if (filter === 'all') {
                row.style.display = '';
            } else {
                const status = row.getAttribute('data-status');
                row.style.display = status === filter ? '' : 'none';
            }
        });
    }
}