// Export Management Module
class ExportManager {
    constructor(suppliersApp) {
        this.suppliersApp = suppliersApp;
    }

    init() {
        this.setupExportListeners();
    }

    setupExportListeners() {
        // Export buttons
        document.querySelectorAll('.export-btn').forEach(btn => {
            btn.addEventListener('click', (e) => this.handleExport(e));
        });
    }

    async handleExport(event) {
        const type = event.target.closest('.vendor-section').id.includes('service') ? 
            'service-providers' : 'suppliers';
        
        try {
            const response = await fetch(`/service-providers/export?type=${type}`, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            });

            if (response.ok) {
                const blob = await response.blob();
                const url = window.URL.createObjectURL(blob);
                const a = document.createElement('a');
                a.style.display = 'none';
                a.href = url;
                a.download = `${type}-${new Date().toISOString().split('T')[0]}.csv`;
                document.body.appendChild(a);
                a.click();
                window.URL.revokeObjectURL(url);
                document.body.removeChild(a);
            } else {
                throw new Error('Export failed');
            }
        } catch (error) {
            console.error('Error exporting data:', error);
            this.suppliersApp.showAlert('Error exporting data', 'error');
        }
    }
}