<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\ShipmentMode;

class ShipmentModesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Disable foreign key checks to allow truncation
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        ShipmentMode::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        ShipmentMode::insert([
            [
                'code' => 'courier',
                'name' => 'Courier',
                'volumetric_divisor' => 5000,
            ],
            [
                'code' => 'standard_air',
                'name' => 'Standard Air',
                'volumetric_divisor' => 6000,
            ],
            [
                'code' => 'air_consolidated',
                'name' => 'Air Consolidated',
                'volumetric_divisor' => 6000,
            ],
            [
                'code' => 'sea_consolidated',
                'name' => 'Sea Consolidated',
                'volumetric_divisor' => 1, // Not used for air volumetric
            ],
        ]);
    }
}
