<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('service_provider_routes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_provider_id')->constrained()->onDelete('cascade');
            $table->string('route_name');
            $table->string('origin');
            $table->string('destination');
            $table->decimal('minimum_chargeable', 10, 2)->default(0);
            $table->decimal('volumetric_divisor', 10, 2)->default(5000);
            $table->enum('chargeable_type', ['volumetric_weight', 'gross_weight', 'net_volume']);
            $table->enum('shipping_method', ['air', 'sea', 'land', 'rail'])->default('land');
            $table->integer('transit_days')->nullable();
            $table->decimal('rate_per_kg', 10, 2)->nullable();
            $table->decimal('rate_per_volume', 10, 2)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('service_provider_routes');
    }
};