<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::table('services', function (Blueprint $table) {
        $table->foreignId('default_currency_id')
              ->nullable()
              ->constrained('currencies')
              ->onDelete('set null');
    });
}

public function down()
{
    Schema::table('services', function (Blueprint $table) {
        $table->dropForeign(['default_currency_id']);
        $table->dropColumn('default_currency_id');
    });
}
};
