<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
    Schema::create('measures', function (Blueprint $table) {
        $table->id();
        $table->string('code')->unique(); // e.g., 'kg', 'cbm', 'cuft'
        $table->string('name');          // e.g., 'Kilogram', 'Cubic Meter', 'Cubic Foot'
        $table->timestamps();
    });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('measures');
    }
};
