<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
    Schema::create('services', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->decimal('cost_amount', 10, 2);
        $table->foreignId('cost_currency_id')->constrained('currencies');
        $table->decimal('selling_price', 10, 2);
        $table->foreignId('charge_currency_id')->constrained('currencies');
        $table->decimal('profit_margin', 10, 2)->default(0);
        $table->timestamps();
    });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
