<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
 public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();

            $table->foreignId('shipment_id')->constrained()->onDelete('cascade');
            $table->integer('package_no');

            $table->string('origin_tracking_number')->nullable(); // NEW
            $table->string('tracking_no')->unique()->nullable();  // UPDATED

            $table->decimal('length', 8, 2);
            $table->decimal('width', 8, 2);
            $table->decimal('height', 8, 2);
            $table->decimal('weight', 8, 2);
            $table->decimal('volumetric_weight', 8, 2)->nullable();
            $table->decimal('chargeable_weight', 8, 2)->nullable();

            $table->text('cargo_description')->nullable();
            $table->text('images')->nullable(); // JSON image array
            $table->string('label_path')->nullable(); // NEW

            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};
