<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
    Schema::create('shipments', function (Blueprint $table) {
        $table->id();
        $table->foreignId('customer_id')->constrained();
        $table->string('tracking_number')->unique();
        $table->enum('shipment_type', ['standard_air', 'standard_sea', 'air_consolidated', 'sea_consolidated']);
        $table->foreignId('origin_country_id')->constrained('countries');
        $table->foreignId('destination_country_id')->constrained('countries');
        $table->integer('number_of_packages');
        $table->decimal('total_charge', 12, 2);
        $table->decimal('expected_income', 12, 2)->default(0);
        $table->foreignId('charge_currency_id')->constrained('currencies');
        $table->enum('status', ['pending', 'loaded', 'in_transit', 'delivered', 'collected'])->default('pending');
        $table->foreignId('created_by')->nullable()->constrained('users');
        $table->foreignId('category_id')->constrained('cargo_categories')->nullable();
        $table->timestamps();
    });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipments');
    }
};
