<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up(): void
{
    Schema::create('currencies', function (Blueprint $table) {
        $table->id();
        $table->string('code')->unique(); // KES, USD, etc.
        $table->string('name');
        $table->string('symbol')->nullable(); // Optional
        $table->decimal('buying_exchange_rate', 10, 4)->default(1);
        $table->decimal('selling_exchange_rate', 10, 4)->default(1);
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currencies');
    }
};
