<?php
namespace App\Services;

use App\Models\ShipmentRoute;

class FreightCalculator
{
    public function calculate($weight, $volume, $cuft, $routeId, $mode, $categoryId): array
    {
        $route = ShipmentRoute::find($routeId);
        $chargeable = 0;
        $rate = $route->rate;
        $unit = $route->unit; // kg, cbm, cuft

        if ($unit === 'cbm') {
            $chargeable = $volume;
        } elseif ($unit === 'cuft') {
            $chargeable = $cuft;
        } elseif ($unit === 'kg') {
            $volumetric = ($volume * 1000000) / ($route->divisor ?? 5000);
            $chargeable = max($weight, $volumetric);
        }

        return [
            'chargeable' => round($chargeable, 2),
            'total' => round($rate * $chargeable, 2)
        ];
    }
}
