<?php
// app/Rules/UniqueServicePerShipment.php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class UniqueServicePerShipment implements Rule
{
    protected $shipment;
    
    public function __construct($shipment)
    {
        $this->shipment = $shipment;
    }
    
    public function passes($attribute, $value)
    {
        if (!$this->shipment) {
            return true;
        }
        
        return !$this->shipment->services()
            ->where('service_id', $value)
            ->exists();
    }
    
    public function message()
    {
        return 'Each service can only be added once per shipment.';
    }
}