<?php

namespace App\Models\Vendors;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ServiceProviderRoute extends Model
{
    use HasFactory;

    protected $fillable = [
        'service_provider_id',
        'route_name',
        'origin',
        'destination',
        'minimum_chargeable',
        'volumetric_divisor',
        'chargeable_type',
        'shipping_method',
        'transit_days',
        'rate_per_kg',
        'rate_per_volume',
        'is_active'
    ];

    protected $casts = [
        'minimum_chargeable' => 'decimal:2',
        'volumetric_divisor' => 'decimal:2',
        'rate_per_kg' => 'decimal:2',
        'rate_per_volume' => 'decimal:2',
        'transit_days' => 'integer',
        'is_active' => 'boolean'
    ];

    // Relationships
    public function serviceProvider(): BelongsTo
    {
        return $this->belongsTo(ServiceProvider::class);
    }

    public function weightBands(): HasMany
    {
        return $this->hasMany(ServiceProviderWeightBand::class, 'route_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByShippingMethod($query, $method)
    {
        return $query->where('shipping_method', $method);
    }
}