<?php

namespace App\Models\Vendors; // Change from App\Models to App\Models\Vendors

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ServiceProvider extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type',
        'vendor_code',
        'onboarding_date',
        'open_balance',
        'balance_type',
        'contact_person',
        'email',
        'phone',
        'address',
        'account_number',
        'status',
        'is_default',
        'notes'
    ];

    protected $casts = [
        'onboarding_date' => 'date',
        'open_balance' => 'decimal:2',
        'is_default' => 'boolean'
    ];

    // Relationships
    public function routes(): HasMany
    {
        return $this->hasMany(ServiceProviderRoute::class);
    }

    public function payments(): HasMany
    {
        return $this->hasMany(SupplierPayment::class);
    }

    public function inhouseRoute(): HasOne
    {
        return $this->hasOne(ServiceProviderRoute::class)->where('is_active', true);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    public function scopeServiceProviders($query)
    {
        return $query->where('type', 'service_provider');
    }

    public function scopeSuppliers($query)
    {
        return $query->where('type', 'supplier');
    }

    public function scopeDefault($query)
    {
        return $query->where('is_default', true);
    }
}