<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ShipmentRoute extends Model
{
    protected $fillable = [
        'origin_country_id',
        'destination_country_id',
        'shipment_mode_id',
        'cargo_category_id', 
        'currency_id',
        'rate_per_unit',
        'flat_rate',
        'minimum_weight',
        'unit_type',
        'weight_basis',
    ];

    protected $with = [
        'originCountry',
        'destinationCountry',
        'shipmentMode.measure',
        'cargoCategory',
    ];

    public function originCountry()
    {
        return $this->belongsTo(Country::class, 'origin_country_id');
    }

    public function destinationCountry()
    {
        return $this->belongsTo(Country::class, 'destination_country_id');
    }

    public function shipmentMode()
    {
        return $this->belongsTo(ShipmentMode::class, 'shipment_mode_id');
    }

    public function cargoCategory()
    {
        return $this->belongsTo(CargoCategory::class, 'cargo_category_id'); // ✅ FIXED
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
}
