<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ShipmentMode extends Model
{
    use HasFactory;

    protected $fillable = ['code', 'name', 'volume_divisor', 'measure_id'];

    public function routes()
    {
        return $this->hasMany(ShipmentRoute::class);
    }

    public function measure()
    {
        return $this->belongsTo(Measure::class);
    }
}
