<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'cost_currency_id',
        'cost_amount',
        'selling_price',
        'charge_currency_id',
    ];

    public function shipmentServices()
    {
        return $this->hasMany(ShipmentService::class);
    }

    public function costCurrency()
    {
        return $this->belongsTo(Currency::class, 'cost_currency_id');
    }

    public function chargeCurrency()
    {
        return $this->belongsTo(Currency::class, 'charge_currency_id');
    }
}
