<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    protected $fillable = [
        'shipment_id',
        'package_no',
        'length',
        'width',
        'height',
        'weight',
        'volumetric_weight',
        'chargeable_weight',
        'tracking_no',
        'cargo_description',
    ];

    public function shipment()
    {
        return $this->belongsTo(Shipment::class);
    }
}
