<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\Currency;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    public function index() {
        $services = Service::with(['costCurrency', 'chargeCurrency'])->get();
        return view('services.index', compact('services'));
    }

    public function create() {
        return view('services.create', [
            'currencies' => Currency::all(),
        ]);
    }

    public function store(Request $request) {
        $request->validate([
            'name' => 'required',
            'default_currency_id' => 'required|exists:currencies,id',
        ]);

        Service::create($request->all());
        return redirect()->route('services.index')->with('success', 'Service added');
    }

    public function edit(Service $service) {
        return view('services.edit', [
            'service'    => $service,
            'currencies' => Currency::all(),
        ]);
    }

    public function update(Request $request, Service $service) {
        $request->validate([
            'name' => 'required',
            'default_currency_id' => 'required|exists:currencies,id',
        ]);

        $service->update($request->all());
        return redirect()->route('services.index')->with('success', 'Service updated');
    }

    public function destroy(Service $service) {
        $service->delete();
        return back()->with('success', 'Service deleted');
    }
}

