<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function index() {
        $customers = Customer::latest()->get();
        return view('customers.index', compact('customers'));
    }

    public function create() {
        return view('customers.create');
    }

    public function store(Request $request) {
        $request->validate([
            'name'  => 'required|string|max:255',
            'phone' => 'required|unique:customers',
        ]);

        Customer::create($request->all());
        return redirect()->route('customers.index')->with('success', 'Customer created');
    }

    public function edit(Customer $customer) {
        return view('customers.edit', compact('customer'));
    }

    public function update(Request $request, Customer $customer) {
        $request->validate([
            'name'  => 'required',
            'phone' => 'required|unique:customers,phone,' . $customer->id,
        ]);

        $customer->update($request->all());
        return redirect()->route('customers.index')->with('success', 'Customer updated');
    }

    public function destroy(Customer $customer) {
        $customer->delete();
        return back()->with('success', 'Customer deleted');
    }
}

